/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.service.session;

import org.mule.runtime.module.tooling.api.artifact.DeclarationSession;
import org.mule.tooling.api.service.session.DeclarationSessionContainer;

public class DefaultDeclarationSessionContainer implements DeclarationSessionContainer {

  private final String id;
  private final DeclarationSession declarationSession;

  public DefaultDeclarationSessionContainer(String id,
                                            DeclarationSession declarationSession) {
    this.id = id;
    this.declarationSession = declarationSession;
  }

  @Override
  public String getId() {
    return id;
  }

  @Override
  public DeclarationSession getSession() {
    return declarationSession;
  }

}
