/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.service.session;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;
import static java.util.Optional.empty;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.api.artifact.DeclarationSession;
import org.mule.runtime.module.tooling.api.artifact.DeclarationSessionBuilder;
import org.mule.tooling.api.service.session.DeclarationSessionContainer;

import org.junit.Before;
import org.junit.Test;

public class DefaultDeclarationSessionAgentServiceTestCase {

  private DefaultDeclarationSessionAgentService service = new DefaultDeclarationSessionAgentService();
  private ToolingService mockedToolingService;
  private DeclarationSession mockedSession;

  @Before
  public void setupToolingService() {
    mockedSession = mock(DeclarationSession.class);

    DeclarationSessionBuilder sessionBuilder = mock(DeclarationSessionBuilder.class);
    when(sessionBuilder.addDependency(any())).thenReturn(sessionBuilder);
    when(sessionBuilder.addDependency(any(), any(), any(), any(), any())).thenReturn(sessionBuilder);
    when(sessionBuilder.setArtifactDeclaration(any())).thenReturn(sessionBuilder);
    when(sessionBuilder.setArtifactProperties(any())).thenReturn(sessionBuilder);
    when(sessionBuilder.setArtifactProperties(any())).thenReturn(sessionBuilder);
    when(sessionBuilder.build()).thenReturn(mockedSession);

    mockedToolingService = mock(ToolingService.class);

    service.setToolingService(mockedToolingService);
    when(mockedToolingService.newDeclarationSessionBuilder()).thenReturn(sessionBuilder);
  }

  @Test
  public void createAndGetSession() {
    DeclarationSessionContainer sessionContainer = service.createDeclarationSession(emptyList(),
                                                                                    null,
                                                                                    emptyMap());
    assertThat(service.getSession(sessionContainer.getId()).get(), is(sessionContainer));
  }

  @Test
  public void getNonExistentSession() {
    assertThat(service.getSession("notExistent"), is(empty()));
  }
}
