/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.MDC;

public interface LoggingHandler {
    public static final String REQUEST_ID_HEADER_NAME = "X-B3-TraceId";
    public static final String MDC_TRACE_ID_KEY = "traceId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T withLoggingContext(Optional<String> requestIdHeader, Supplier<T> responseSupplier) {
        requestIdHeader.ifPresent(id -> MDC.put((String)MDC_TRACE_ID_KEY, (String)id));
        try {
            T t = responseSupplier.get();
            return t;
        }
        finally {
            MDC.remove((String)MDC_TRACE_ID_KEY);
        }
    }
}

