/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.service.session;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.module.tooling.api.ArtifactAgnosticServiceBuilder;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.api.ToolingServiceAware;
import org.mule.runtime.module.tooling.api.artifact.DeclarationSession;
import org.mule.runtime.module.tooling.api.artifact.DeclarationSessionBuilder;
import org.mule.tooling.api.service.session.DeclarationSessionAgentService;
import org.mule.tooling.api.service.session.DeclarationSessionContainer;
import org.mule.tooling.internal.service.AbstractConfigurableService;
import org.mule.tooling.internal.service.session.DefaultDeclarationSessionContainer;

@Named(value="org.mule.tooling.service.session")
@Singleton
public class DefaultDeclarationSessionAgentService
extends AbstractConfigurableService
implements DeclarationSessionAgentService,
ToolingServiceAware {
    private Map<String, DeclarationSessionContainer> createdSessions = new ConcurrentHashMap<String, DeclarationSessionContainer>();
    private ToolingService muleToolingService;

    public void setToolingService(ToolingService toolingService) {
        this.muleToolingService = toolingService;
    }

    @Override
    public DeclarationSessionContainer createDeclarationSession(List<ArtifactAgnosticServiceBuilder.Dependency> dependencies, ArtifactDeclaration artifactDeclaration, Map<String, String> sessionProperties) {
        String id = UUID.getUUID();
        if (this.createdSessions.containsKey(id)) {
            throw new IllegalStateException(String.format("A session with id: %s is already created ", id));
        }
        DeclarationSessionBuilder builder = this.muleToolingService.newDeclarationSessionBuilder();
        dependencies.forEach(arg_0 -> ((DeclarationSessionBuilder)builder).addDependency(arg_0));
        builder.setArtifactDeclaration(artifactDeclaration);
        builder.setArtifactProperties(sessionProperties);
        DefaultDeclarationSessionContainer declarationSession = new DefaultDeclarationSessionContainer(id, (DeclarationSession)builder.build());
        this.createdSessions.put(id, declarationSession);
        return declarationSession;
    }

    @Override
    public Optional<DeclarationSessionContainer> getSession(String id) {
        return Optional.ofNullable(this.createdSessions.get(id));
    }

    @Override
    public boolean deleteSession(String id) {
        DeclarationSessionContainer sessionContainer = this.createdSessions.remove(id);
        if (sessionContainer != null) {
            sessionContainer.getSession().dispose();
            return true;
        }
        return false;
    }
}

