/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.handler.sampledata;

import com.google.inject.Inject;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.services.ToolingService;
import com.mulesoft.agent.util.ResponseHelper;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mule.runtime.api.component.location.Location;
import org.mule.tooling.api.serialization.Serializer;
import org.mule.tooling.api.serialization.SerializerFactory;
import org.mule.tooling.api.service.Configuration;
import org.mule.tooling.api.service.artifact.DeployableArtifactAgentService;
import org.mule.tooling.api.service.expression.RuntimeAgentService;
import org.mule.tooling.internal.handler.LoggingHandler;
import org.mule.tooling.internal.sampledata.SampleDataResultTransformer;

@Singleton
@Named(value="org.mule.tooling.sampledata.handler")
@Path(value="/tooling")
public class SampleDataServiceAgentHandler
implements ExternalMessageHandler,
LoggingHandler {
    private static final String VERBOSE_QUERY_PARAM = "verbose";
    private static final String APPLICATIONS = "applications";
    private static final String COMPONENTS = "components";
    private static final String APP_ID = "applicationId";
    private static final String COMPONENT_PATH = "componentPath";
    private static final String SAMPLE_DATA = "sampledata";
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final ResponseHelper responseHelper = new ResponseHelper().addErrorMapping(NoSuchApplicationException.class, Response.Status.NOT_FOUND).addErrorMapping(NoSuchElementException.class, Response.Status.NOT_FOUND);
    private final Serializer serializer = SerializerFactory.jsonSerializer();
    @Inject
    private ToolingService toolingService;
    @Inject
    private RuntimeAgentService runtimeAgentService;
    @Inject
    private DeployableArtifactAgentService deployableArtifactService;
    @Inject
    private Configuration configuration;

    public void enable(boolean b) throws AgentEnableOperationException {
        this.enabled.set(true);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    @GET
    @Path(value="applications/{applicationId}/components/{componentPath}/sampledata")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSampleData(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="applicationId") String appId, @PathParam(value="componentPath") String componentPath, @QueryParam(value="verbose") boolean verboseErrors) {
        try {
            return this.responseHelper.response(() -> this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> this.serializer.serialize(SampleDataResultTransformer.toComponentSampleDataResult(this.deployableArtifactService.getSampleData(this.toolingService.getDeployedApplication(appId), Location.builderFromStringRepresentation((String)componentPath).build()), this.runtimeAgentService.getExpressionLanguage(), this.configuration.getSampleDataMaxPayloadSize()))));
        }
        catch (Exception e) {
            return this.responseHelper.failure(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), e, verboseErrors);
        }
    }
}

