/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.sampledata;

import static java.lang.String.valueOf;
import static java.nio.charset.Charset.defaultCharset;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.tooling.api.serialization.SerializerFactory.jsonSerializer;

import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.tooling.api.sampledata.SampleDataMessageModelFailure;
import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;
import org.mule.tooling.event.model.DataTypeModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;

import java.nio.charset.Charset;

import org.junit.Test;

public class SampleDataMessageModelResultSerializationTestCase {

  @Test
  public void success() {
    SampleDataMessageModelResult sampleDataMessageModelResult = new SampleDataMessageModelResult(createMessageModel());
    String serialized = jsonSerializer().serialize(sampleDataMessageModelResult);
    SampleDataMessageModelResult deserialized = jsonSerializer().deserialize(serialized, SampleDataMessageModelResult.class);
    assertThat(deserialized.isSuccess(), is(true));
    assertThat(deserialized.getSampleData().isPresent(), is(true));
    assertThat(new String(deserialized.getSampleData().get().getPayload().getContent(), defaultCharset()), is("payload"));
    assertThat(new String(deserialized.getSampleData().get().getAttributes().getContent(), defaultCharset()), is("attributes"));
  }

  @Test
  public void failure() {
    SampleDataMessageModelResult sampleDataMessageModelResult =
        new SampleDataMessageModelResult(new SampleDataMessageModelFailure("fail", "fail", "fail"));
    String serialized = jsonSerializer().serialize(sampleDataMessageModelResult);
    SampleDataMessageModelResult deserialized = jsonSerializer().deserialize(serialized, SampleDataMessageModelResult.class);
    assertThat(deserialized.isSuccess(), is(false));
    assertThat(deserialized.getFailure().isPresent(), is(true));
    assertThat(deserialized.getFailure().get().getMessage(), is("fail"));
  }

  private MessageModel createMessageModel() {
    TypedValue<String> payload = TypedValue.of("payload");
    TypedValue<String> attributes = TypedValue.of("attributes");

    return MessageModel.builder().withPayload(createTypedValueModel(payload))
        .withAttributes(createTypedValueModel(attributes)).build();
  }

  private TypedValueModel createTypedValueModel(TypedValue<String> typedValue) {
    Charset encoding = defaultCharset();
    TypedValueModel.Builder typedValueModelBuilder = TypedValueModel.builder();
    typedValueModelBuilder.withDataType(DataTypeModel.builder()
        .withType(typedValue.getDataType().getType().getName())
        .withMediaType(MediaType.create(typedValue.getDataType().getMediaType().getPrimaryType(),
                                        typedValue.getDataType().getMediaType().getSubType(), encoding)
            .toRfcString())
        .build());
    typedValueModelBuilder.withContent(valueOf(typedValue.getValue()).getBytes(encoding));

    return typedValueModelBuilder.build();
  }
}
