/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extensions.metadata.internal.metadata;

import java.util.HashSet;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKey;
import org.mule.tooling.extensions.metadata.api.source.StringAttributes;
import org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysOutputTypeResolver;

public class MultiLevelPartialTypeKeysOutputTypeResolver
extends MultiLevelTypeKeysOutputTypeResolver
implements PartialTypeKeysResolver<LocationKey> {
    public static final String AMERICA = "AMERICA";
    public static final String EUROPE = "EUROPE";
    public static final String FRANCE = "FRANCE";
    public static final String ARGENTINA = "ARGENTINA";
    public static final String USA = "USA";
    public static final String USA_DISPLAY_NAME = "United States";
    public static final String BUENOS_AIRES = "BA";
    public static final String LA_PLATA = "LPLT";
    public static final String PARIS = "PRS";
    public static final String SAN_FRANCISCO = "SFO";

    public static MetadataKey resolveLocationKeyChildren(LocationKey partial) throws MetadataResolvingException {
        if (AMERICA.equalsIgnoreCase(partial.getContinent())) {
            if (ARGENTINA.equalsIgnoreCase(partial.getCountry())) {
                return MetadataKeyBuilder.newKey((String)AMERICA).withDisplayName(AMERICA).withChild(MetadataKeyBuilder.newKey((String)ARGENTINA).withChild(MetadataKeyBuilder.newKey((String)BUENOS_AIRES)).withChild(MetadataKeyBuilder.newKey((String)LA_PLATA))).build();
            }
            return MultiLevelPartialTypeKeysOutputTypeResolver.buildAmericaKey();
        }
        if (EUROPE.equalsIgnoreCase(partial.getContinent())) {
            return MultiLevelPartialTypeKeysOutputTypeResolver.buildEuropeKey();
        }
        throw new MetadataResolvingException("Invalid Continent", FailureCode.INVALID_METADATA_KEY);
    }

    @Override
    public String getCategoryName() {
        return this.getClass().getSimpleName();
    }

    public MetadataKey resolveChilds(MetadataContext context, LocationKey partial) throws MetadataResolvingException {
        return MultiLevelPartialTypeKeysOutputTypeResolver.resolveLocationKeyChildren(partial);
    }

    @Override
    public MetadataType getOutputType(MetadataContext metadataContext, LocationKey locationKey) throws MetadataResolvingException, ConnectionException {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().defaultValue(locationKey.toString()).build();
    }

    @Override
    public MetadataType getInputMetadata(MetadataContext metadataContext, LocationKey locationKey) throws MetadataResolvingException, ConnectionException {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().defaultValue(locationKey.toString()).build();
    }

    @Override
    public MetadataType getAttributesType(MetadataContext metadataContext, LocationKey locationKey) throws MetadataResolvingException, ConnectionException {
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(StringAttributes.class.getName());
        objectTypeBuilder.addField().key("value").value((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().defaultValue(locationKey.toString()).build()).build();
        return objectTypeBuilder.build();
    }

    @Override
    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        HashSet<MetadataKey> keys = new HashSet<MetadataKey>();
        keys.add(MetadataKeyBuilder.newKey((String)AMERICA).build());
        keys.add(MetadataKeyBuilder.newKey((String)EUROPE).build());
        return keys;
    }

    @Override
    public String getResolverName() {
        return this.getClass().getSimpleName();
    }
}

