package org.mule.tooling.extensions.metadata.internal.metadata;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import static org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysOutputTypeResolver.buildAmericaKey;
import static org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysOutputTypeResolver.buildEuropeKey;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKeyWithDefaults;

import java.util.HashSet;
import java.util.Set;

public class MultiLevelTypeKeysInputLocationKeyWithDefaultsResolver implements TypeKeysResolver,
        InputTypeResolver<LocationKeyWithDefaults> {
  @Override
  public String getCategoryName() {
    return this.getClass().getSimpleName();
  }

  @Override
  public MetadataType getInputMetadata(MetadataContext metadataContext, LocationKeyWithDefaults locationKey) throws MetadataResolvingException, ConnectionException {
    return BaseTypeBuilder.create(JAVA).stringType().defaultValue(locationKey.toString()).build();
  }

  @Override
  public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
    Set keys = new HashSet<>();
    keys.add(buildAmericaKey());
    keys.add(buildEuropeKey());
    return keys;
  }

  @Override
  public String getResolverName() {
    return this.getClass().getSimpleName();
  }

}
