package org.mule.tooling.extensions.metadata.internal.value.provider.sdk;

import static java.util.Collections.singleton;
import static org.mule.sdk.api.values.ValueBuilder.newValue;

import org.mule.sdk.api.values.Value;
import org.mule.sdk.api.values.ValueProvider;

import java.util.Set;

public class MultiLevelVP implements ValueProvider {

  private static final String AMERICA = "America";
  private static final String ARGENTINA = "Argentina";
  private static final String BUENOS_AIRES = "Buenos Aires";
  private static final String LA_PLATA = "La Plata";
  private static final String USA = "USA";
  private static final String USA_DISPLAY_NAME = "United States Of America";
  private static final String SAN_FRANCISCO = "San Francisco";

  @Override
  public Set<Value> resolve() {
    return singleton(newValue(AMERICA).withDisplayName(AMERICA)
            .withChild(newValue(ARGENTINA).withChild(newValue(BUENOS_AIRES))
                    .withChild(newValue(LA_PLATA)))
            .withChild(newValue(USA).withDisplayName(USA_DISPLAY_NAME)
                    .withChild(newValue(SAN_FRANCISCO)))
            .build());
  }

  @Override
  public String getId() {
    return this.getClass().getSimpleName();
  }

}
