package org.mule.tooling.extensions.metadata.internal.connection;

import static org.mule.runtime.api.connection.ConnectionValidationResult.failure;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;

@Alias("tstFailingConnection")
public class TstFailingConnectionProvider implements ConnectionProvider<TstExtensionClient> {

  @Override
  public TstExtensionClient connect() throws ConnectionException {
    throw new ConnectionException("Expected connection exception");
  }

  @Override
  public void disconnect(TstExtensionClient ewmClient) {}

  @Override
  public ConnectionValidationResult validate(TstExtensionClient tstClient) {
    return failure("Expected validate exception", new IllegalStateException());
  }

}
