package org.mule.tooling.extensions.metadata.internal.metadata.sdk;

import static org.mule.metadata.api.model.MetadataFormat.JSON;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.resolving.InputStaticTypeResolver;

public class TypeWithFieldResolver extends InputStaticTypeResolver {

  @Override
  public MetadataType getStaticMetadata() {
    MetadataType stringType = BaseTypeBuilder.create(JSON).stringType().build();
    MetadataType intType = BaseTypeBuilder.create(JSON).numberType().build();

    ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create(JSON).objectType();
    objectTypeBuilder.addField().key("field").value(stringType);
    objectTypeBuilder.addField().key("stringParam").value(stringType);

    MetadataType simpleListType= BaseTypeBuilder.create(JSON).arrayType().of(stringType).build();
    MetadataType simpleMapType= BaseTypeBuilder.create(JSON).objectType().openWith(stringType).build();

    ObjectTypeBuilder innerPojoObjectTypeBuilder = BaseTypeBuilder.create(JSON).objectType();
    innerPojoObjectTypeBuilder.addField().key("stringParam").value(stringType);
    innerPojoObjectTypeBuilder.addField().key("intParam").value(intType);
    innerPojoObjectTypeBuilder.addField().key("simpleListParam").value(simpleListType);
    innerPojoObjectTypeBuilder.addField().key("simpleMapParam").value(simpleMapType);

    objectTypeBuilder.addField().key("innerPojoParam").value(innerPojoObjectTypeBuilder);

    ObjectTypeBuilder levelTwoTypeBuilder = BaseTypeBuilder.create(JSON).objectType();
    levelTwoTypeBuilder.addField().key("field").value(stringType);

    MetadataType innerPojoListType = BaseTypeBuilder.create(JSON).arrayType().of(innerPojoObjectTypeBuilder).build();
    MetadataType innerPojoMapType = BaseTypeBuilder.create(JSON).objectType().openWith(innerPojoObjectTypeBuilder).build();

    ObjectTypeBuilder complexActingParameterBuilder = BaseTypeBuilder.create(JSON).objectType();
    complexActingParameterBuilder.addField().key("stringParam").value(stringType);
    complexActingParameterBuilder.addField().key("intParam").value(intType);
    complexActingParameterBuilder.addField().key("innerPojoParam").value(innerPojoObjectTypeBuilder);
    complexActingParameterBuilder.addField().key("simpleListParam").value(simpleListType);
    complexActingParameterBuilder.addField().key("simpleMapParam").value(simpleMapType);
    complexActingParameterBuilder.addField().key("complexListParam").value(innerPojoListType);
    complexActingParameterBuilder.addField().key("complexMapParam").value(innerPojoMapType);

    ObjectTypeBuilder levelOneTypeBuilder = BaseTypeBuilder.create(JSON).objectType();
    levelOneTypeBuilder.addField().key("levelTwo").value(levelTwoTypeBuilder);
    levelOneTypeBuilder.addField().key("complexField").value(complexActingParameterBuilder);

    objectTypeBuilder.addField().key("levelOne").value(levelOneTypeBuilder);

    return objectTypeBuilder.build();
  }
}
