package org.mule.tooling.extensions.metadata.internal.operation;

import static org.mule.runtime.extension.api.annotation.param.MediaType.APPLICATION_XML;
import static org.mule.runtime.extension.api.annotation.param.MediaType.TEXT_PLAIN;

import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.data.sample.SampleData;
import org.mule.sdk.api.annotation.values.FieldValues;
import org.mule.tooling.extensions.metadata.api.parameters.ActingParameterGroup;
import org.mule.tooling.extensions.metadata.api.parameters.ActingParameterGroupWithAlias;
import org.mule.tooling.extensions.metadata.api.parameters.ComplexActingParameter;
import org.mule.tooling.extensions.metadata.api.parameters.InnerPojo;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKey;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKeyAllOptionals;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKeyExpressionDefaults;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKeyWithDefaults;
import org.mule.tooling.extensions.metadata.api.parameters.SimpleParametersContainer;
import org.mule.tooling.extensions.metadata.api.parameters.GroupAsMultiLevelValue;
import org.mule.tooling.extensions.metadata.internal.config.SimpleConfiguration;
import org.mule.tooling.extensions.metadata.internal.connection.TstExtensionClient;
import org.mule.tooling.extensions.metadata.internal.metadata.ConfigLessConnectionLessMetadataResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.ConfigLessMetadataResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.LocationAllOptionalsMetadataResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelPartialTypeKeysOutputTypeResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysInputLocationKeyExpressionDefaultsResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysInputLocationKeyWithDefaultsResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysOutputTypeResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.InternalErrorMetadataResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.OutputTypeKeyResolverUsesResourcesCache;
import org.mule.tooling.extensions.metadata.internal.metadata.RequiresConfigurationOutputTypeKeyResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.sdk.DummyTypeResolver;
import org.mule.tooling.extensions.metadata.internal.metadata.sdk.TypeWithFieldResolver;
import org.mule.tooling.extensions.metadata.internal.operation.enums.EnumParameterType;
import org.mule.tooling.extensions.metadata.internal.sampledata.ActingParameterGroupOptionalSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.ActingParameterGroupOptionalWithDefaultInContainerSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.ActingParameterGroupSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.ActingParameterSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.ComplexActingParameterSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.ConfigLessConnectionLessSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.ConfigLessSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.ErrorSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.InternalErrorSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.sampledata.StringActingParameterSampleDataProvider;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ActingParameterGroupVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ActingParameterGroupVPWithAlias;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ActingParameterVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ComplexActingParameterVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ConfigLessConnectionLessNoActingParamVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ConfigLessNoActingParamVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ErrorVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.LevelThreeVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.LevelTwoVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.MultiLevelValueProvider;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.MultipleValuesSimpleVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.InternalErrorVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.SimpleActingParametersVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.SimpleParametersContainerVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.extensions.ValueProviderWithConfiguration;
import org.mule.tooling.extensions.metadata.internal.value.provider.sdk.MultiLevelVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.sdk.SimpleVP;
import org.mule.tooling.extensions.metadata.internal.value.provider.sdk.StringActingParameterVP;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.xml.datatype.XMLGregorianCalendar;

public class SimpleOperations {

  @OutputResolver(output = ConfigLessConnectionLessMetadataResolver.class)
  @SampleData(ConfigLessConnectionLessSampleDataProvider.class)
  @MediaType(TEXT_PLAIN)
  public Result<Object, Void> enumExportedWithDefaultValueOP(@Optional @OfValues(ConfigLessConnectionLessNoActingParamVP.class) String vpParam,
                                                                @Optional(defaultValue = "INTERNAL") EnumParameterType enumParameterType,
                                                             @MetadataKeyId(ConfigLessConnectionLessMetadataResolver.class) String metadataKey) {
    return null;
  }


  public Result<Void, Void> sameVPUsedInMoreThanOneParameterOP(@Optional @OfValues(ConfigLessConnectionLessNoActingParamVP.class) String userOrigin,
                                                               @Optional @OfValues(ConfigLessConnectionLessNoActingParamVP.class) String userTarget) {
    return null;
  }

  @OutputResolver(output = ConfigLessConnectionLessMetadataResolver.class)
  @SampleData(ConfigLessConnectionLessSampleDataProvider.class)
  public Result<Object, Void> configLessConnectionLessOP(@Config SimpleConfiguration configuration,
                                                         @Connection TstExtensionClient client,
                                                         @Optional @OfValues(ConfigLessConnectionLessNoActingParamVP.class) String providedParameter,
                                                         @MetadataKeyId(ConfigLessConnectionLessMetadataResolver.class) String metadataKey) {
    return null;
  }

  @OutputResolver(output = ConfigLessMetadataResolver.class)
  @SampleData(ConfigLessSampleDataProvider.class)
  public Result<Object, Void> configLessOP(@Config SimpleConfiguration configuration,
                                           @Connection TstExtensionClient client,
                                           @Optional @OfValues(ConfigLessNoActingParamVP.class) String providedParameter,
                                           @Optional(defaultValue = "item") @MetadataKeyId(ConfigLessMetadataResolver.class) String metadataKey) {
    return null;
  }


  @OutputResolver(output = InternalErrorMetadataResolver.class, attributes = InternalErrorMetadataResolver.class)
  public Result<Object, Object> internalErrorMetadataResolverOP(@Optional(defaultValue = "item") @MetadataKeyId(InternalErrorMetadataResolver.class) String metadataKey,
                                                                @TypeResolver(InternalErrorMetadataResolver.class) String inputParam) {
    return null;
  }


  @OutputResolver(output = ConfigLessMetadataResolver.class)
  @SampleData(ConfigLessSampleDataProvider.class)
  public Result<Object, Void> configLessMetadataKeyExpressionDefaultValueOP(@Config SimpleConfiguration configuration,
                                                                            @Connection TstExtensionClient client,
                                                                            @Optional @OfValues(ConfigLessNoActingParamVP.class) String providedParameter,
                                                                            @Optional(defaultValue = "#['item']") @MetadataKeyId(ConfigLessMetadataResolver.class) String metadataKey) {
    return null;
  }

  @MediaType(TEXT_PLAIN)
  @OutputResolver(output = MultiLevelPartialTypeKeysOutputTypeResolver.class, attributes = MultiLevelPartialTypeKeysOutputTypeResolver.class)
  public Result<String, Object> multiLevelPartialTypeKeysMetadataKey(
          @MetadataKeyId(MultiLevelPartialTypeKeysOutputTypeResolver.class) @ParameterGroup(name = "LocationKey") LocationKey locationKey,
          @TypeResolver(MultiLevelPartialTypeKeysOutputTypeResolver.class) Map<String, Object> dynamicParam) {
    return null;
  }

  @MediaType(TEXT_PLAIN)
  @OutputResolver(output = MultiLevelTypeKeysOutputTypeResolver.class, attributes = MultiLevelTypeKeysOutputTypeResolver.class)
  public Result<String, Object> multiLevelTypeKeyMetadataKey(
          @MetadataKeyId(MultiLevelTypeKeysOutputTypeResolver.class) @ParameterGroup(name = "LocationKey") LocationKey locationKey,
          @TypeResolver(MultiLevelTypeKeysOutputTypeResolver.class) Map<String, Object> dynamicParam) {
    return null;
  }

  @MediaType(TEXT_PLAIN)
  public Result<String, Object> multiLevelTypeKeyMetadataKeyWithDefaults(
          @MetadataKeyId(MultiLevelTypeKeysInputLocationKeyWithDefaultsResolver.class) @ParameterGroup(name = "LocationKeyWithDefaults") LocationKeyWithDefaults locationKeyWithDefaults,
          @TypeResolver(MultiLevelTypeKeysInputLocationKeyWithDefaultsResolver.class) Map<String, Object> dynamicParam) {
    return null;
  }

  @MediaType(TEXT_PLAIN)
  public Result<String, Object> multiLevelTypeKeyMetadataKeyExpressionDefaults(
          @MetadataKeyId(MultiLevelTypeKeysInputLocationKeyExpressionDefaultsResolver.class) @ParameterGroup(name = "LocationKeyExpressionDefaults") LocationKeyExpressionDefaults locationKeyExpressionDefaults,
          @TypeResolver(MultiLevelTypeKeysInputLocationKeyExpressionDefaultsResolver.class) Map<String, Object> dynamicParam) {
    return null;
  }

  @MediaType(TEXT_PLAIN)
  @OutputResolver(output = MultiLevelPartialTypeKeysOutputTypeResolver.class)
  public Result<String, Object> multiLevelShowInDslGroupPartialTypeKeysMetadataKey(
          @Config SimpleConfiguration configuration,
          @Connection TstExtensionClient client,
          @MetadataKeyId(MultiLevelPartialTypeKeysOutputTypeResolver.class) @ParameterGroup(name = "LocationKeyShowInDsl", showInDsl = true) LocationKey locationKeyShowInDslParam) {
    return null;
  }

  @MediaType(TEXT_PLAIN)
  @OutputResolver(output = RequiresConfigurationOutputTypeKeyResolver.class)
  public Result<String, Object> requiresConfigurationOutputTypeKeyResolver(
          @MetadataKeyId(RequiresConfigurationOutputTypeKeyResolver.class) String type) {
    return null;
  }

  @MediaType(TEXT_PLAIN)
  @OutputResolver(output = OutputTypeKeyResolverUsesResourcesCache.class)
  public Result<String, Object> resolverUsesResourcesCache(
          @Config SimpleConfiguration configuration,
          @Connection TstExtensionClient client,
          @MetadataKeyId(OutputTypeKeyResolverUsesResourcesCache.class) String type) {
    return null;
  }

  @SampleData(ActingParameterSampleDataProvider.class)
  public Result<Integer, Object> actingParameterOP(@Config SimpleConfiguration configuration,
                                                   @Connection TstExtensionClient client,
                                                   String otherRequiredParameterNotRequiredForMetadataNeitherValueProvider,
                                                   String actingParameter,
                                                   @Optional @OfValues(ActingParameterVP.class) String providedParameter,
                                                   @Optional @OfValues(ErrorVP.class) String errorProvidedParameter,
                                                   @Optional @OfValues(InternalErrorVP.class) String internalErrorProvidedParameter) {
    return null;
  }

  public Result<Void, Object> multiLevelParameterGroupWithCloseValueProviderOP(@OfValues(value = MultiLevelValueProvider.class, open = false)
                                                                               @ParameterGroup(name = "LocationKey")
                                                                                       GroupAsMultiLevelValue optionsParameter) {
    return null;
  }

  public Result<Void, Object> simpleActingParametersOP(@Config SimpleConfiguration configuration,
                                                       @Connection TstExtensionClient client,
                                                       int intParam,
                                                       boolean booleanParam,
                                                       Date dateParam,
                                                       java.sql.Date sqlDateParam,
                                                       LocalDate localDateParam,
                                                       LocalDateTime localDateTimeParam,
                                                       Calendar calendarParam,
                                                       XMLGregorianCalendar xmlGregorianCalendarParam,
                                                       TimeUnit enumParam,
                                                       @Optional @OfValues(SimpleActingParametersVP.class) String providedParameter) {
    return null;
  }

  public Result<Void, Object> simpleActingParametersInContainerOP(@Config SimpleConfiguration configuration,
                                                                  @Connection TstExtensionClient client,
                                                                  SimpleParametersContainer simpleParametersContainer,
                                                                  @Optional @OfValues(SimpleParametersContainerVP.class) String providedParameter) {
    return null;
  }

  @SampleData(ErrorSampleDataProvider.class)
  public Result<Integer, Object> errorSampleDataOP() {
    return null;
  }

  @SampleData(InternalErrorSampleDataProvider.class)
  public Result<Integer, Object> internalErrorSampleDataOP() {
    return null;
  }

  @SampleData(ActingParameterSampleDataProvider.class)
  public Result<Integer, Object> actingParameterOptionalOP(@Config SimpleConfiguration configuration,
                                                           @Connection TstExtensionClient client,
                                                           @Optional(defaultValue = "actingDefault") String actingParameter,
                                                           @Optional @OfValues(ActingParameterVP.class) String providedParameter) {
    return null;
  }

  @SampleData(ActingParameterSampleDataProvider.class)
  public Result<Integer, Object> actingParameterOptionalWithoutDefaultOP(@Config SimpleConfiguration configuration,
                                                                         @Connection TstExtensionClient client,
                                                                         @Optional String actingParameter,
                                                                         @Optional @OfValues(ActingParameterVP.class) String providedParameter) {
    return null;
  }


  @SampleData(ActingParameterSampleDataProvider.class)
  public Result<Integer, Object> actingParameterOptionalWithDefaultExpressionValueOP(@Config SimpleConfiguration configuration,
                                                                                     @Connection TstExtensionClient client,
                                                                                     @Optional(defaultValue = "#['actingDefaultExpressionValue']") String actingParameter,
                                                                                     @Optional @OfValues(ActingParameterVP.class) String providedParameter) {
    return null;
  }

  //TODO: add hint to utils
  @SampleData(ActingParameterSampleDataProvider.class)
  public Result<Integer, Object> actingParameterOptionalWithDefaultContextDependentExpressionValueOP(@Config SimpleConfiguration configuration,
                                                                                                     @Connection TstExtensionClient client,
                                                                                                     @Optional(defaultValue = "#[payload.actingParameter]") String actingParameter,
                                                                                                     @Optional @OfValues(ActingParameterVP.class) String providedParameter) {
    return null;
  }

  public Result<Void, Object> parameterValueProviderWithConfig(@OfValues(ValueProviderWithConfiguration.class) String providedParameter) {
    return null;
  }

  @SampleData(ComplexActingParameterSampleDataProvider.class)
  public Result<Integer, String> complexActingParameterOP(@Config SimpleConfiguration configuration,
                                                          @Connection TstExtensionClient client,
                                                          ComplexActingParameter actingParameter,
                                                          @Optional @OfValues(ComplexActingParameterVP.class) String providedParameter) {
    return null;
  }

  @SampleData(ActingParameterGroupSampleDataProvider.class)
  public Result<Integer, String> actingParameterGroupOP(@Config SimpleConfiguration configuration,
                                                        @Connection TstExtensionClient client,
                                                        @ParameterGroup(name = "Acting") ActingParameterGroup actingParameterGroup,
                                                        @Optional @OfValues(ActingParameterGroupVP.class) String providedParameter) {
    return null;
  }

  @SampleData(ActingParameterGroupOptionalSampleDataProvider.class)
  public Result<Integer, String> actingParameterGroupWithOptionalProviderParamOP(@Config SimpleConfiguration configuration,
                                                                                 @Connection TstExtensionClient client,
                                                                                 @ParameterGroup(name = "Acting") ActingParameterGroup actingParameterGroup) {
    return null;
  }

  @SampleData(ActingParameterGroupOptionalWithDefaultInContainerSampleDataProvider.class)
  public Result<Integer, String> actingParameterGroupWithOptionalWithDefaultInContainerProviderParamOP(@Config SimpleConfiguration configuration,
                                                                                                       @Connection TstExtensionClient client,
                                                                                                       @ParameterGroup(name = "Acting") ActingParameterGroup actingParameterGroup) {
    return null;
  }

  @SampleData(ActingParameterGroupSampleDataProvider.class)
  public Result<Integer, String> actingParameterGroupWithAliasOP(@Config SimpleConfiguration configuration,
                                                                 @Connection TstExtensionClient client,
                                                                 @ParameterGroup(name = "Acting") ActingParameterGroupWithAlias actingParameterGroup,
                                                                 @Optional @OfValues(ActingParameterGroupVPWithAlias.class) String providedParameter) {
    return null;
  }

  @SampleData(ActingParameterSampleDataProvider.class)
  public Result<Integer, Object> nestedVPsOperation(@Config SimpleConfiguration configuration,
                                                    @Connection TstExtensionClient client,
                                                    @Optional @OfValues(MultipleValuesSimpleVP.class) String actingParameter,
                                                    @Optional @OfValues(ActingParameterVP.class) String providedParameter) {
    return null;
  }

  public Result<Void, Object> multipleNestedVPsOperation(@Config SimpleConfiguration configuration,
                                                         @Connection TstExtensionClient client,
                                                         @Optional @OfValues(MultipleValuesSimpleVP.class) String levelOne,
                                                         @Optional @OfValues(LevelTwoVP.class) String levelTwo,
                                                         @Optional @OfValues(LevelThreeVP.class) String providedParameter) {
    return null;
  }

  @Ignore
  public Result<Void, Object> ignoredOperation() {
    return null;
  }

  @SampleData(value = StringActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "otherParameter"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<String, Void> vpWithBindingToTopLevel(
          @org.mule.sdk.api.annotation.values.OfValues(
                  value = StringActingParameterVP.class,
                  bindings = {
                          @Binding(actingParameter = "actingParameter", extractionExpression = "otherParameter")
                  }) String providedParameter,
          String otherParameter) {
    return null;
  }

  public Result<Void, Object> vpWithBindingToField(
          @org.mule.sdk.api.annotation.values.OfValues(
                  value = StringActingParameterVP.class,
                  bindings = {
                          @Binding(actingParameter = "actingParameter", extractionExpression = "innerPojo.stringParam")
                  }) String providedParameter,
          InnerPojo innerPojo) {
    return null;
  }

  public Result<Void, Object> vpOnPojoFieldOperation(@FieldValues(value = SimpleVP.class, targetSelectors = "stringParam") InnerPojo innerPojo) {
    return null;
  }

  public Result<Void, Object> vpOnPojoDeepFieldOperation(@FieldValues(value = SimpleVP.class, targetSelectors = "innerPojoParam.stringParam") ComplexActingParameter complexActingParameter) {
    return null;
  }

  public Result<Void, Object> vpOnPojoDependsOnTopLevelOperation(@FieldValues(value = StringActingParameterVP.class, targetSelectors = "stringParam") InnerPojo innerPojo, String actingParameter) {
    return null;
  }

  @SampleData(
          value = StringActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "complexActingParameter.innerPojoParam.stringParam"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<String, Void> vpOnPojoDependsOnOwnFieldOperation(
          @FieldValues(
                  value = StringActingParameterVP.class,
                  targetSelectors = "stringParam",
                  bindings = @Binding(
                          actingParameter = "actingParameter",
                          extractionExpression = "complexActingParameter.innerPojoParam.stringParam")
          ) ComplexActingParameter complexActingParameter) {
    return null;
  }

  @SampleData(
          value = StringActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "actingInnerPojo.stringParam"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<String, Void> vpOnPojoDependsOnOtherFieldOperation(
          @FieldValues(
                  value = StringActingParameterVP.class,
                  targetSelectors = "stringParam",
                  bindings = {
                          @Binding(
                                  actingParameter = "actingParameter",
                                  extractionExpression = "actingInnerPojo.stringParam")
                  }) InnerPojo innerPojo,
          InnerPojo actingInnerPojo) {
    return null;
  }

  public Result<Void, Object> vpOnPojoMultipleFieldsOperation(
          @FieldValues(value = SimpleVP.class, targetSelectors = "innerPojoParam.stringParam")
          @FieldValues(value = SimpleVP.class, targetSelectors = "stringParam")
                  ComplexActingParameter complexActingParameter) {
    return null;
  }

  public Result<Void, Object> vpOnPojoMultiLevelFieldsOperation(@FieldValues(value = MultiLevelVP.class, targetSelectors = {"continent", "country", "city"}) GroupAsMultiLevelValue multiLevelValue) {
    return null;
  }

  public Result<Void, Object> vpOnContentFieldOperation(@FieldValues(value = SimpleVP.class, targetSelectors = "stringParam")
                                                        @TypeResolver(TypeWithFieldResolver.class) String parameter) {
    return null;
  }

  public Result<Void, Object> vpOnContentDeepFieldOperation(@FieldValues(value = SimpleVP.class, targetSelectors = "innerPojoParam.stringParam")
                                                            @TypeResolver(TypeWithFieldResolver.class) String parameter) {
    return null;
  }

  public Result<Void, Object> vpOnContentDependsOnTopLevelOperation(@FieldValues(value = StringActingParameterVP.class, targetSelectors = "stringParam")
                                                                    @TypeResolver(TypeWithFieldResolver.class) String parameter, String actingParameter) {
    return null;
  }

  @SampleData(
          value = StringActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "parameter.field"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<String, Void> vpOnContentDependsOnOwnFieldOperation(
          @FieldValues(
                  value = StringActingParameterVP.class,
                  targetSelectors = "stringParam",
                  bindings = {
                          @Binding(actingParameter = "actingParameter", extractionExpression = "parameter.field")
                  })
          @TypeResolver(TypeWithFieldResolver.class) String parameter) {
    return null;
  }

  @SampleData(
          value = StringActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "parameter.field.@attribute"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<String, Void> vpOnContentDependsOnOwnAttributeOperation(
          @FieldValues(
                  value = StringActingParameterVP.class,
                  targetSelectors = "stringParam",
                  bindings = {
                          @Binding(actingParameter = "actingParameter", extractionExpression = "parameter.field.@attribute")
                  })
                  String parameter) {
    return null;
  }

  @SampleData(
          value = StringActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "parameter.levelOne.levelTwo.field"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<String, Void> vpOnContentDependsOnOwnDeepFieldOperation(
          @FieldValues(
                  value = StringActingParameterVP.class,
                  targetSelectors = "stringParam",
                  bindings = {
                          @Binding(actingParameter = "actingParameter", extractionExpression = "parameter.levelOne.levelTwo.field")
                  })
          @TypeResolver(TypeWithFieldResolver.class) String parameter) {
    return null;
  }

  @SampleData(
          value = ComplexActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "parameter.levelOne.complexField"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<Integer, String> vpOnContentDependsOnOwnDeepFieldAsPojoOperation(
          @FieldValues(
                  value = org.mule.tooling.extensions.metadata.internal.value.provider.sdk.ComplexActingParameterVP.class,
                  targetSelectors = "stringParam",
                  bindings = {
                          @Binding(actingParameter = "actingParameter", extractionExpression = "parameter.levelOne.complexField")
                  })
          @TypeResolver(TypeWithFieldResolver.class) String parameter) {
    return null;
  }


  public Result<Void, Object> vpOnContentMultipleFieldsOperation(
          @FieldValues(value = SimpleVP.class, targetSelectors = "innerPojoParam.stringParam")
          @FieldValues(value = SimpleVP.class, targetSelectors = "stringParam")
          @TypeResolver(TypeWithFieldResolver.class) String parameter) {
    return null;
  }

  public Result<Void, Object> vpWithMultipleMultiLevelsOnContent(
          @FieldValues(value = MultiLevelVP.class, targetSelectors = {"location0.continent", "location0.country", "location0.city"})
          @FieldValues(value = MultiLevelVP.class, targetSelectors = {"location1.continent", "location1.country", "location1.city"})
          @TypeResolver(DummyTypeResolver.class) String parameter) {
    return null;
  }

  public Result<Void, Object> vpOnStreamFieldOperation(@FieldValues(value = SimpleVP.class, targetSelectors = "stringParam")
                                                       @TypeResolver(TypeWithFieldResolver.class) InputStream parameter) {
    return null;
  }

  public Result<Void, Object> vpOnStreamDeepFieldOperation(@FieldValues(value = SimpleVP.class, targetSelectors = "innerPojoParam.stringParam")
                                                           @TypeResolver(TypeWithFieldResolver.class) InputStream parameter) {
    return null;
  }

  public Result<Void, Object> vpOnStreamDependsOnTopLevelOperation(@FieldValues(value = StringActingParameterVP.class, targetSelectors = "stringParam")
                                                                   @TypeResolver(TypeWithFieldResolver.class) InputStream parameter,
                                                                   String actingParameter) {
    return null;
  }

  @SampleData(
          value = StringActingParameterSampleDataProvider.class,
          bindings = @Binding(
                  actingParameter = "actingParameter",
                  extractionExpression = "parameter.field"
          ))
  @MediaType(TEXT_PLAIN)
  public Result<String, Void> vpOnStreamDependsOnOwnFieldOperation(
          @FieldValues(value = StringActingParameterVP.class,
                  targetSelectors = "stringParam",
                  bindings = {
                          @Binding(actingParameter = "actingParameter", extractionExpression = "parameter.field")
                  })
          @TypeResolver(TypeWithFieldResolver.class) InputStream parameter) {
    return null;
  }

  public Result<Void, Object> vpOnStreamMultipleFieldsOperation(
          @FieldValues(value = SimpleVP.class, targetSelectors = "innerPojoParam.stringParam")
          @FieldValues(value = SimpleVP.class, targetSelectors = "stringParam")
          @TypeResolver(TypeWithFieldResolver.class) InputStream parameter) {
    return null;
  }

  @OutputResolver(
          output = LocationAllOptionalsMetadataResolver.class,
          attributes = LocationAllOptionalsMetadataResolver.class)
  public Result<Object, Object> metadataKeyWithOptionalsOperation(@ParameterGroup(name = "LocationKey")
                                                                  @MetadataKeyId(LocationAllOptionalsMetadataResolver.WithKeyResolver.class)
                                                                          LocationKeyAllOptionals location) {
    return null;
  }

  @OutputResolver(
          output = LocationAllOptionalsMetadataResolver.class,
          attributes = LocationAllOptionalsMetadataResolver.class)
  public Result<Object, Object> metadataKeyWithOptionalsAndPartialKeyOperation(@ParameterGroup(name = "LocationKey")
                                                                                @MetadataKeyId(LocationAllOptionalsMetadataResolver.WithPartialKeyResolver.class)
                                                                                        LocationKeyAllOptionals location) {
    return null;
  }

}
