/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.extensions.metadata.internal.sampledata;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;

import java.util.List;

public class ActingParameterGroupOptionalWithDefaultInContainerSampleDataProvider implements SampleDataProvider<Integer, String> {

  @Parameter
  @Optional
  private String stringParam;
  @Parameter
  @Optional(defaultValue = "-1")
  private int intParam;

  @Parameter
  private List<String> listParams;

  @Override
  public String getId() {
    return getClass().getSimpleName();
  }

  @Override
  public Result<Integer, String> getSample() throws SampleDataException {
    final StringBuilder sb = new StringBuilder()
            .append(stringParam).append("-")
            .append(intParam);
    listParams.forEach(p -> sb.append("-").append(p));
    return Result.<Integer, String>builder().attributes(sb.toString()).build();
  }
}
