/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.extensions.metadata.api.source;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.tooling.extensions.metadata.internal.config.SimpleConfiguration;
import org.mule.tooling.extensions.metadata.internal.connection.TstExtensionClient;
import org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelPartialTypeKeysOutputTypeResolver;

@Alias("ignored")
@MediaType(value = "text/plain")
@Ignore
public class IgnoredSource extends Source<String, StringAttributes> {

  @Config
  private SimpleConfiguration config;

  @Connection
  private ConnectionProvider<TstExtensionClient> connection;

  @Override
  public void onStart(SourceCallback<String, StringAttributes> sourceCallback) throws MuleException { }

  @OnSuccess
  public void onSuccess(@TypeResolver(MultiLevelPartialTypeKeysOutputTypeResolver.class) String onSuccessParameter,
                        SourceCallbackContext callbackContext)
          throws Exception {
  }

  @OnTerminate
  public void onTerminate() {}

  @Override
  public void onStop() { }

}
