/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;

@Mojo(name="load-extension-models", defaultPhase=LifecyclePhase.COMPILE)
public class LoadExtensionModelsMojo
extends AbstractMojo {
    @Parameter(property="settings.localRepository", required=true)
    private String localRepo;
    @Parameter(property="target-repo-dir", required=true)
    private String targetRepo;
    @Parameter(property="settingsLocation", required=true)
    private String settingsFile;
    @Parameter(property="mule-version", required=true)
    private String muleVersion;
    @Parameter(property="properties-path", required=true)
    private String propertiesPath;
    @Parameter(property="exchangeUrl", required=true)
    private String exchangeUrl;
    @Parameter(defaultValue="false", property="settings.offline")
    private Boolean offline;
    @Parameter(property="tooling", required=true)
    private String tooling;
    @Parameter(property="tooling-cache-path", required=true)
    private String toolingCachePath;
    public static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    public static final String ALL_DEFAULT_MODULES = "all";
    private static final String DEPENDENCIES_SEPARATOR = ",";
    private static final String TOOLING_PATH_PROPERTY = "tooling.client.ExtensionModelServiceCache.diskStore.path";

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        long start = System.currentTimeMillis();
        ToolingRuntimeClientBootstrap clientBootstrap = null;
        String originalPathCache = System.getProperties().getProperty(TOOLING_PATH_PROPERTY, "");
        try {
            log.info((CharSequence)("Resolving tooling client dependencies using tooling.version " + this.tooling + " for mule.version " + this.muleVersion));
            System.setProperty(TOOLING_PATH_PROPERTY, this.toolingCachePath);
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(this.propertiesPath);){
                properties.load(reader);
            }
            File tempFolder = com.google.common.io.Files.createTempDir();
            MavenConfiguration mavenConfiguration = this.newToolingMavenConfiguration(this.localRepo, this.settingsFile, this.offline, this.exchangeUrl, "");
            File toolingCache = new File(this.toolingCachePath);
            if (!toolingCache.exists() && !toolingCache.mkdir()) {
                throw new RuntimeException("Could not create directory:" + this.toolingCachePath);
            }
            ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder toolingRuntimeConfigBuilder = ToolingRuntimeClientBootstrapConfiguration.builder().workingFolder(tempFolder).toolingVersion(this.tooling);
            ToolingRuntimeClientBootstrapConfiguration toolingRuntimeConfig = toolingRuntimeConfigBuilder.mavenConfiguration(mavenConfiguration).muleVersion(this.muleVersion).workingFolder(tempFolder).build();
            clientBootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap((ToolingRuntimeClientBootstrapConfiguration)toolingRuntimeConfig);
            log.info((CharSequence)("Building tooling client for tooling.version " + this.tooling + " and mule.version " + this.muleVersion));
            ToolingRuntimeClient.Builder builder = clientBootstrap.getToolingRuntimeClientBuilderFactory().create();
            ToolingRuntimeClient toolingClient = builder.withMavenConfiguration(this.newToolingMavenConfiguration(this.targetRepo, this.settingsFile, this.offline, this.exchangeUrl, this.localRepo)).build();
            if (toolingClient == null) {
                throw new RuntimeException("Failed to create tooling client for tooling.version " + toolingClient + " and mule.version " + this.muleVersion);
            }
            log.info((CharSequence)"Tooling client built successfully");
            String artifactsRepository = this.targetRepo;
            List<ArtifactDescriptor> allArtifacts = this.getArtifactFiles(properties, ALL_DEFAULT_MODULES);
            allArtifacts.stream().forEach(file -> {
                try {
                    Optional extensionModel = toolingClient.extensionModelService().loadExtensionModel(file);
                    if (extensionModel.isPresent()) {
                        log.info((CharSequence)("Successfully loaded " + ((ExtensionModel)extensionModel.get()).getName()));
                    } else {
                        log.error((CharSequence)("No failure occurred but no extension model was loaded for: " + file));
                    }
                    this.extractPomFileFromArtifact((ArtifactDescriptor)file, artifactsRepository);
                }
                catch (Throwable e) {
                    log.error((CharSequence)("Unexpected error loading extension model for: " + file));
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                System.setProperty(TOOLING_PATH_PROPERTY, originalPathCache);
                long end = System.currentTimeMillis();
                long spent = (end - start) / 1000L;
                String time = spent > 60L ? spent / 60L + " minutes " + spent % 60L + " seconds" : spent + " seconds";
                log.info((CharSequence)("Finished after " + time));
                if (clientBootstrap != null) {
                    clientBootstrap.dispose();
                }
                throw throwable;
            }
        }
        System.setProperty(TOOLING_PATH_PROPERTY, originalPathCache);
        long end = System.currentTimeMillis();
        long spent = (end - start) / 1000L;
        String time = spent > 60L ? spent / 60L + " minutes " + spent % 60L + " seconds" : spent + " seconds";
        log.info((CharSequence)("Finished after " + time));
        if (clientBootstrap != null) {
            clientBootstrap.dispose();
        }
    }

    private List<ArtifactDescriptor> getArtifactFiles(Properties properties, String artifactList) {
        return Arrays.stream(properties.getProperty(artifactList, "").split(DEPENDENCIES_SEPARATOR)).map(line -> line.trim()).filter(line -> !line.isEmpty()).map(line -> this.createArtifactDescriptor((String)line)).collect(Collectors.toList());
    }

    private ArtifactDescriptor createArtifactDescriptor(String line) {
        String[] split = line.split(":");
        return this.createArtifactDescriptor(split[0], split[1], split[2]);
    }

    private ArtifactDescriptor createArtifactDescriptor(String groupId, String artifactId, String version) {
        return ArtifactDescriptor.newBuilder().withArtifactId(artifactId).withGroupId(groupId).withVersion(version).withClassifier(MULE_PLUGIN_CLASSIFIER).build();
    }

    private MavenConfiguration newToolingMavenConfiguration(String localRepoPath, String settingsFile, boolean offline, String exchangeUrl, String localAsRemotePath) throws IOException {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder();
        mavenConfigurationBuilder.forcePolicyUpdateNever(true);
        mavenConfigurationBuilder.localMavenRepositoryLocation(new File(localRepoPath));
        mavenConfigurationBuilder.ignoreArtifactDescriptorRepositories(false);
        if (StringUtils.isNotBlank((String)localAsRemotePath)) {
            mavenConfigurationBuilder.remoteRepository(new RemoteRepository.RemoteRepositoryBuilder().id("local-as-remote").url(new File(localAsRemotePath).toPath().toUri().toURL()).build());
        }
        if (!offline) {
            RemoteRepository snapshotsRepository = new RemoteRepository.RemoteRepositoryBuilder().id("mulesoft-snapshots").url(new URL("https://repository-master.mulesoft.org/nexus/content/repositories/snapshots/")).build();
            RemoteRepository releasesRepository = new RemoteRepository.RemoteRepositoryBuilder().id("mulesoft-releases").url(new URL("https://repository-master.mulesoft.org/nexus/content/repositories/releases/")).build();
            RemoteRepository exchangeRepository = new RemoteRepository.RemoteRepositoryBuilder().id("anypoint-exchange").url(new URL(exchangeUrl)).build();
            mavenConfigurationBuilder.remoteRepository(snapshotsRepository);
            mavenConfigurationBuilder.remoteRepository(releasesRepository);
            mavenConfigurationBuilder.remoteRepository(exchangeRepository);
            mavenConfigurationBuilder.remoteRepository(new RemoteRepository.RemoteRepositoryBuilder().id("central").url(new URL("https://repo.maven.apache.org/maven2/")).build());
            mavenConfigurationBuilder.userSettingsLocation(new File(settingsFile));
        }
        return mavenConfigurationBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPomFileFromArtifact(ArtifactDescriptor artifactDescriptor, String artifactsRepository) throws IOException {
        File artifactFile = this.getFileInLocalRepo(artifactDescriptor, artifactsRepository);
        Log log = this.getLog();
        try (ZipFile zip = null;){
            zip = new ZipFile(artifactFile);
            String entryPath = "META-INF/maven/" + artifactDescriptor.getGroupId() + "/" + artifactDescriptor.getArtifactId() + "/pom.xml";
            ZipEntry pomEntry = zip.getEntry(entryPath);
            try (InputStream pomContents = zip.getInputStream(pomEntry);){
                File pomPath = new File(artifactFile.getParent(), artifactDescriptor.getArtifactId() + "-" + artifactDescriptor.getVersion() + ".pom");
                log.info((CharSequence)("Extracting entry" + entryPath + " from " + artifactFile + " into " + pomPath));
                Files.copy(pomContents, pomPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                log.info((CharSequence)("Successfully extracted POM file from " + artifactDescriptor.getArtifactId() + " into " + pomPath));
            }
        }
    }

    private File getFileInLocalRepo(ArtifactDescriptor dependency, String artifactsRepository) {
        return new File(artifactsRepository + File.separator + this.getRepositoryPath(dependency, File.separator));
    }

    private String getRepositoryPath(ArtifactDescriptor artifact, String pathSeparator) {
        StringBuilder builder = new StringBuilder();
        for (String groupSegment : artifact.getGroupId().split("\\.")) {
            builder.append(groupSegment);
            builder.append(pathSeparator);
        }
        builder.append(artifact.getArtifactId()).append(pathSeparator).append(artifact.getVersion()).append(pathSeparator).append(artifact.getArtifactId()).append("-").append(artifact.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().trim().isEmpty()) {
            builder.append("-").append(artifact.getClassifier());
        }
        builder.append(".").append(artifact.getExtension());
        return builder.toString();
    }
}

