/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.tools.ToolingClientBasedMojoTemplate;

@Mojo(name="load-extension-models", defaultPhase=LifecyclePhase.COMPILE)
public class LoadExtensionModelsMojo
extends ToolingClientBasedMojoTemplate {
    private static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    private static final String ALL_DEFAULT_MODULES = "all";
    private static final String DEPENDENCIES_SEPARATOR = ",";
    @Parameter(property="settings.localRepository", required=true)
    private String localRepo;
    @Parameter(property="target-repo-dir", required=true)
    private String targetRepo;
    @Parameter(property="properties-path", required=true)
    private String propertiesPath;
    @Parameter(property="exchangeUrl", required=true)
    private String exchangeUrl;
    @Parameter(property="tooling-cache-path", required=true)
    private String toolingCachePath;

    @Override
    protected MavenConfiguration createToolingClientMavenConfiguration() throws IOException, MojoExecutionException {
        return this.newToolingMavenConfiguration(this.localRepo, this.settingsFile, this.offline, this.exchangeUrl, "");
    }

    @Override
    public void doExecute(Log log, ToolingRuntimeClientBootstrap clientBootstrap) throws MojoExecutionException, IOException {
        log.info((CharSequence)("Building tooling client for tooling.version " + this.tooling + " and mule.version " + this.muleVersion));
        ToolingRuntimeClient.Builder builder = clientBootstrap.getToolingRuntimeClientBuilderFactory().create();
        ToolingRuntimeClient toolingClient = builder.withMavenConfiguration(this.newToolingMavenConfiguration(this.targetRepo, this.settingsFile, this.offline, this.exchangeUrl, this.localRepo)).build();
        if (toolingClient == null) {
            throw new MojoExecutionException("Failed to create tooling client for tooling.version " + this.tooling + " and mule.version " + this.muleVersion);
        }
        log.info((CharSequence)"Tooling client built successfully");
        String artifactsRepository = this.targetRepo;
        List<ArtifactDescriptor> allArtifacts = this.getArtifactFiles(ALL_DEFAULT_MODULES);
        for (ArtifactDescriptor descriptor : allArtifacts) {
            try {
                Optional extensionModel = toolingClient.extensionModelService().loadExtensionModel(descriptor);
                if (extensionModel.isPresent()) {
                    log.info((CharSequence)("Successfully loaded " + ((ExtensionModel)extensionModel.get()).getName()));
                } else {
                    log.warn((CharSequence)("No failure occurred but no extension model was loaded for: " + descriptor));
                }
                this.extractPomFileFromArtifact(descriptor, artifactsRepository);
            }
            catch (Throwable e) {
                log.error((CharSequence)("Unexpected error loading extension model for: " + descriptor));
                throw new MojoExecutionException("Unexpected error", e);
            }
        }
    }

    @Override
    protected void configureToolingCache(String originalPathCache) {
        System.setProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", this.toolingCachePath);
        File toolingCache = new File(this.toolingCachePath);
        if (!toolingCache.exists() && !toolingCache.mkdir()) {
            throw new RuntimeException("Could not create directory:" + this.toolingCachePath);
        }
    }

    private List<ArtifactDescriptor> getArtifactFiles(String artifactList) throws IOException {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(this.propertiesPath);){
            properties.load(reader);
        }
        return Arrays.stream(properties.getProperty(artifactList, "").split(DEPENDENCIES_SEPARATOR)).map(line -> line.trim()).filter(line -> !line.isEmpty()).map(line -> this.createArtifactDescriptor((String)line)).collect(Collectors.toList());
    }

    private ArtifactDescriptor createArtifactDescriptor(String line) {
        String[] split = line.split(":");
        return this.createArtifactDescriptor(split[0], split[1], split[2]);
    }

    private ArtifactDescriptor createArtifactDescriptor(String groupId, String artifactId, String version) {
        return ArtifactDescriptor.newBuilder().withArtifactId(artifactId).withGroupId(groupId).withVersion(version).withClassifier(MULE_PLUGIN_CLASSIFIER).build();
    }

    private MavenConfiguration newToolingMavenConfiguration(String localRepoPath, String settingsFile, boolean offline, String exchangeUrl, String localAsRemotePath) throws IOException, MojoExecutionException {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = this.getBaseMavenConfBuilder(settingsFile, localRepoPath, offline);
        mavenConfigurationBuilder.ignoreArtifactDescriptorRepositories(false);
        if (StringUtils.isNotBlank((String)localAsRemotePath)) {
            mavenConfigurationBuilder.remoteRepository(this.createRemoteRepoFor("local-as-remote", new File(localAsRemotePath)));
        }
        if (!offline) {
            RemoteRepository exchangeRepository = this.createRemoteRepoFor("anypoint-exchange", exchangeUrl);
            mavenConfigurationBuilder.remoteRepository(exchangeRepository);
        }
        return mavenConfigurationBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPomFileFromArtifact(ArtifactDescriptor artifactDescriptor, String artifactsRepository) throws IOException {
        File artifactFile = this.getFileInLocalRepo(artifactDescriptor, artifactsRepository);
        Log log = this.getLog();
        try (ZipFile zip = null;){
            zip = new ZipFile(artifactFile);
            String entryPath = "META-INF/maven/" + artifactDescriptor.getGroupId() + "/" + artifactDescriptor.getArtifactId() + "/pom.xml";
            ZipEntry pomEntry = zip.getEntry(entryPath);
            try (InputStream pomContents = zip.getInputStream(pomEntry);){
                File pomPath = new File(artifactFile.getParent(), artifactDescriptor.getArtifactId() + "-" + artifactDescriptor.getVersion() + ".pom");
                log.debug((CharSequence)("Extracting entry " + entryPath + " from " + artifactFile + " into " + pomPath));
                Files.copy(pomContents, pomPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                log.debug((CharSequence)("Successfully extracted POM file from " + artifactDescriptor.getArtifactId() + " into " + pomPath));
            }
        }
    }

    private File getFileInLocalRepo(ArtifactDescriptor dependency, String artifactsRepository) {
        return new File(artifactsRepository + File.separator + this.getRepositoryPath(dependency, File.separator));
    }

    private String getRepositoryPath(ArtifactDescriptor artifact, String pathSeparator) {
        StringBuilder builder = new StringBuilder();
        for (String groupSegment : artifact.getGroupId().split("\\.")) {
            builder.append(groupSegment);
            builder.append(pathSeparator);
        }
        builder.append(artifact.getArtifactId()).append(pathSeparator).append(artifact.getVersion()).append(pathSeparator).append(artifact.getArtifactId()).append("-").append(artifact.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().trim().isEmpty()) {
            builder.append("-").append(artifact.getClassifier());
        }
        builder.append(".").append(artifact.getExtension());
        return builder.toString();
    }
}

