/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;

public abstract class ToolingClientBasedMojoTemplate
extends AbstractMojo {
    @Parameter(property="settingsLocation", required=true)
    protected String settingsFile;
    @Parameter(property="mule-version", required=true)
    protected String muleVersion;
    @Parameter(defaultValue="false", property="settings.offline")
    protected Boolean offline;
    @Parameter(property="tooling", required=true)
    protected String tooling;
    @Parameter(property="checksumPolicy")
    protected String checksumPolicy;
    @Parameter(property="settings.security", required=false)
    protected String settingsSecurityFile;

    protected File getM2Home() {
        return new File(System.getProperty("user.home"), ".m2");
    }

    public void execute() throws MojoExecutionException {
        long end;
        long spent;
        ToolingRuntimeClientBootstrap clientBootstrap;
        long start;
        Log log;
        block7: {
            log = this.getLog();
            start = System.currentTimeMillis();
            clientBootstrap = null;
            String originalPathCache = System.getProperties().getProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", null);
            log.info((CharSequence)("Original tooling cache path: " + originalPathCache));
            try {
                this.configureToolingCache(originalPathCache);
                log.info((CharSequence)("Resolving tooling client dependencies using tooling.version " + this.tooling + " for mule.version " + this.muleVersion));
                log.info((CharSequence)("Using toolingCachePath: " + System.getProperties().getProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", "")));
                clientBootstrap = this.createClientBootstrap();
                this.doExecute(log, clientBootstrap);
                if (originalPathCache == null) break block7;
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Unexpected error.", (Exception)e);
                }
                catch (Throwable throwable) {
                    long end2;
                    long spent2;
                    if (originalPathCache != null) {
                        System.setProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", originalPathCache);
                    }
                    String time = (spent2 = ((end2 = System.currentTimeMillis()) - start) / 1000L) > 60L ? spent2 / 60L + " minutes " + spent2 % 60L + " seconds" : spent2 + " seconds";
                    log.info((CharSequence)("Finished after " + time));
                    if (clientBootstrap != null) {
                        clientBootstrap.dispose();
                    }
                    throw throwable;
                }
            }
            System.setProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", originalPathCache);
        }
        String time = (spent = ((end = System.currentTimeMillis()) - start) / 1000L) > 60L ? spent / 60L + " minutes " + spent % 60L + " seconds" : spent + " seconds";
        log.info((CharSequence)("Finished after " + time));
        if (clientBootstrap != null) {
            clientBootstrap.dispose();
        }
    }

    protected ToolingRuntimeClientBootstrap createClientBootstrap() throws IOException, MojoExecutionException {
        File tempFolder = Files.createTempDir();
        MavenConfiguration mavenConfiguration = this.createToolingClientMavenConfiguration();
        ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder toolingRuntimeConfigBuilder = ToolingRuntimeClientBootstrapConfiguration.builder().workingFolder(tempFolder).toolingVersion(this.tooling);
        ToolingRuntimeClientBootstrapConfiguration toolingRuntimeConfig = toolingRuntimeConfigBuilder.mavenConfiguration(mavenConfiguration).muleVersion(this.muleVersion).workingFolder(tempFolder).build();
        return ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap((ToolingRuntimeClientBootstrapConfiguration)toolingRuntimeConfig);
    }

    protected abstract MavenConfiguration createToolingClientMavenConfiguration() throws IOException, MojoExecutionException;

    protected abstract void doExecute(Log var1, ToolingRuntimeClientBootstrap var2) throws MojoExecutionException, IOException;

    protected abstract void configureToolingCache(String var1);

    protected MavenConfiguration.MavenConfigurationBuilder getBaseMavenConfBuilder(String settingsFile, String localRepository, boolean offline) throws IOException, MojoExecutionException {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder();
        mavenConfigurationBuilder.forcePolicyUpdateNever(true);
        if (StringUtils.isNotBlank((CharSequence)this.checksumPolicy)) {
            mavenConfigurationBuilder.globalChecksumPolicy(this.checksumPolicy);
        }
        mavenConfigurationBuilder.localMavenRepositoryLocation(new File(localRepository));
        this.configureSettingsSecurity(mavenConfigurationBuilder);
        if (!offline) {
            RemoteRepository snapshotsRepository = this.createRemoteRepoFor("mulesoft-snapshots", "https://repository-master.mulesoft.org/nexus/content/repositories/snapshots/");
            RemoteRepository releasesRepository = this.createRemoteRepoFor("mulesoft-releases", "https://repository-master.mulesoft.org/nexus/content/repositories/releases/");
            RemoteRepository central = this.createRemoteRepoFor("central", "https://repo.maven.apache.org/maven2/");
            mavenConfigurationBuilder.remoteRepository(snapshotsRepository);
            mavenConfigurationBuilder.remoteRepository(releasesRepository);
            mavenConfigurationBuilder.remoteRepository(central);
            mavenConfigurationBuilder.userSettingsLocation(new File(settingsFile));
        }
        return mavenConfigurationBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureSettingsSecurity(MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder) throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)this.settingsSecurityFile)) {
            File defaultSettingsSecurity = new File(this.settingsSecurityFile);
            if (!defaultSettingsSecurity.exists()) throw new MojoExecutionException("Unable to resolve settings security file: " + this.settingsSecurityFile + ". Verify the file exists.");
            mavenConfigurationBuilder.settingsSecurityLocation(defaultSettingsSecurity);
            return;
        } else {
            File settingsSecurityLocation = new File(this.getM2Home(), "settings-security.xml");
            if (!settingsSecurityLocation.exists()) return;
            mavenConfigurationBuilder.settingsSecurityLocation(settingsSecurityLocation);
        }
    }

    protected RemoteRepository createRemoteRepoFor(String id, String url) throws MalformedURLException {
        return new RemoteRepository.RemoteRepositoryBuilder().id(id).url(new URL(url)).build();
    }

    protected RemoteRepository createRemoteRepoFor(String id, File file) throws MalformedURLException {
        return new RemoteRepository.RemoteRepositoryBuilder().id(id).url(file.toURI().toURL()).build();
    }
}

