/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;

@Mojo(name="build-tooling-client", defaultPhase=LifecyclePhase.COMPILE)
public class BuildToolingClientModelsMojo
extends AbstractMojo {
    @Parameter(property="client-repo-dir", required=true)
    private String clientRepo;
    @Parameter(property="settingsLocation", required=true)
    private String settingsFile;
    @Parameter(property="mule-version", required=true)
    private String muleVersion;
    @Parameter(property="tooling", required=true)
    private String tooling;
    @Parameter(defaultValue="false", property="settings.offline")
    private Boolean offline;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        long end;
        long spent;
        long start;
        Log log;
        block6: {
            log = this.getLog();
            start = System.currentTimeMillis();
            ToolingRuntimeClientBootstrap clientBootstrap = null;
            try {
                File tempFolder = Files.createTempDir();
                MavenConfiguration mavenConfiguration = this.newToolingMavenConfiguration(this.settingsFile, this.clientRepo, this.offline);
                log.info((CharSequence)("Resolving tooling client dependencies using tooling.version " + this.tooling + " for mule.version " + this.muleVersion));
                ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder toolingRuntimeConfigBuilder = ToolingRuntimeClientBootstrapConfiguration.builder().workingFolder(tempFolder).toolingVersion(this.tooling);
                ToolingRuntimeClientBootstrapConfiguration toolingRuntimeConfig = toolingRuntimeConfigBuilder.mavenConfiguration(mavenConfiguration).muleVersion(this.muleVersion).build();
                clientBootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap((ToolingRuntimeClientBootstrapConfiguration)toolingRuntimeConfig);
                log.info((CharSequence)("Building tooling client for tooling.version " + this.tooling + " and mule.version " + this.muleVersion));
                ToolingRuntimeClient toolingClient = clientBootstrap.getToolingRuntimeClientBuilderFactory().create().build();
                if (toolingClient == null) {
                    throw new RuntimeException("Failed to create tooling client for tooling.version " + this.tooling + " and mule.version " + this.muleVersion);
                }
                log.info((CharSequence)"Tooling client built successfully");
                if (clientBootstrap == null) break block6;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    long end2;
                    long spent2;
                    if (clientBootstrap != null) {
                        clientBootstrap.dispose();
                    }
                    String time = (spent2 = ((end2 = System.currentTimeMillis()) - start) / 1000L) > 60L ? spent2 / 60L + " minutes " + spent2 % 60L + " seconds" : spent2 + " seconds";
                    log.info((CharSequence)("Finished after " + time));
                    throw throwable;
                }
            }
            clientBootstrap.dispose();
        }
        String time = (spent = ((end = System.currentTimeMillis()) - start) / 1000L) > 60L ? spent / 60L + " minutes " + spent % 60L + " seconds" : spent + " seconds";
        log.info((CharSequence)("Finished after " + time));
    }

    private File getM2Home() {
        return new File(System.getProperty("user.home"), ".m2");
    }

    private MavenConfiguration newToolingMavenConfiguration(String settingsFile, String clientRepo, boolean offline) throws IOException {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder();
        mavenConfigurationBuilder.forcePolicyUpdateNever(true);
        mavenConfigurationBuilder.localMavenRepositoryLocation(new File(clientRepo));
        if (!offline) {
            RemoteRepository localRepository = new RemoteRepository.RemoteRepositoryBuilder().id("local-as-remote").url(new File(this.getM2Home(), "repository").toURL()).build();
            RemoteRepository snapshotsRepository = new RemoteRepository.RemoteRepositoryBuilder().id("mulesoft-snapshots").url(new URL("https://repository-master.mulesoft.org/nexus/content/repositories/snapshots/")).build();
            RemoteRepository releasesRepository = new RemoteRepository.RemoteRepositoryBuilder().id("mulesoft-releases").url(new URL("https://repository-master.mulesoft.org/nexus/content/repositories/releases/")).build();
            RemoteRepository central = new RemoteRepository.RemoteRepositoryBuilder().id("central").url(new URL("https://repo.maven.apache.org/maven2/")).build();
            mavenConfigurationBuilder.remoteRepository(localRepository);
            mavenConfigurationBuilder.remoteRepository(snapshotsRepository);
            mavenConfigurationBuilder.remoteRepository(releasesRepository);
            mavenConfigurationBuilder.remoteRepository(central);
            mavenConfigurationBuilder.userSettingsLocation(new File(settingsFile));
        }
        return mavenConfigurationBuilder.build();
    }
}

