/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.runtime.module.embedded.api.dependencies.DependencyResolver;
import org.mule.runtime.module.embedded.api.dependencies.MuleDependenciesResolver;
import org.mule.tooling.tools.support.MavenHelper;
import org.mule.tooling.tools.support.SimpleStopwatch;

@Mojo(name="build-runtime-dependencies", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class BuildRuntimeDependenciesMojo
extends AbstractMojo {
    @Parameter(property="settingsLocation", required=true)
    protected String settingsFile;
    @Parameter(property="settings.security", required=false)
    protected String settingsSecurityFile;
    @Parameter(property="checksumPolicy")
    protected String checksumPolicy;
    @Parameter(defaultValue="false", property="settings.offline")
    protected Boolean offline;
    @Parameter(property="mule-version", required=true)
    protected String muleVersion;
    @Parameter(property="runtime-dependencies-repo-dir", required=true)
    private String runtimeDependenciesRepo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        SimpleStopwatch stopwatch = new SimpleStopwatch().start();
        try {
            log.info((CharSequence)("Resolving dependencies for Runtime version " + this.muleVersion));
            File localAsRemoteRepositoryPath = MavenHelper.getM2LocalRepository();
            MavenConfiguration mavenConfiguration = MavenHelper.getBaseMavenConfBuilder(this.settingsFile, this.settingsSecurityFile, this.runtimeDependenciesRepo, localAsRemoteRepositoryPath, this.offline, this.checksumPolicy).build();
            MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            MavenClient mavenClient = mavenClientProvider.createMavenClient(mavenConfiguration);
            MuleMavenClientDependencyResolver dependencyResolver = new MuleMavenClientDependencyResolver(mavenClient);
            MuleDependenciesResolver muleDependencyResolver = MuleDependenciesResolver.getMuleDependenciesResolver((Product)Product.MULE_EE, (String)this.muleVersion, Collections.emptyList(), (DependencyResolver)dependencyResolver, null, (boolean)false);
            muleDependencyResolver.resolveMuleLibs();
            muleDependencyResolver.resolveMuleServices();
            muleDependencyResolver.resolveServerPlugins();
            muleDependencyResolver.resolveOptLibs();
            log.info((CharSequence)"Dependencies resolved successfully");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unexpected error", (Exception)e);
        }
        finally {
            log.info((CharSequence)("Finished after " + stopwatch.stop().timeSpent()));
        }
    }

    private static class MuleMavenClientDependencyResolver
    implements DependencyResolver {
        private final MavenClient mavenClient;

        public MuleMavenClientDependencyResolver(MavenClient mavenClient) {
            this.mavenClient = mavenClient;
        }

        public List<BundleDependency> resolveBundleDescriptorDependencies(BundleDescriptor descriptor) {
            return this.mavenClient.resolveBundleDescriptorDependencies(false, descriptor);
        }

        public BundleDependency resolveBundleDescriptor(BundleDescriptor descriptor) {
            return this.mavenClient.resolveBundleDescriptor(descriptor);
        }
    }
}

