/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools.support;

public class SimpleStopwatch {
    private long start;
    private long end;

    public SimpleStopwatch start() {
        if (this.start != 0L) {
            throw new IllegalStateException("The stopwatch has already been started");
        }
        this.start = System.currentTimeMillis();
        return this;
    }

    public SimpleStopwatch stop() {
        if (this.end != 0L) {
            throw new IllegalStateException("The stopwatch has not already been stopped");
        }
        this.end = System.currentTimeMillis();
        return this;
    }

    public String timeSpent() {
        if (this.start == 0L) {
            throw new IllegalStateException("The stopwatch has not been started");
        }
        if (this.end == 0L) {
            throw new IllegalStateException("The stopwatch has not been stopped");
        }
        long spent = (this.end - this.start) / 1000L;
        String time = spent > 60L ? spent / 60L + " minutes " + spent % 60L + " seconds" : spent + " seconds";
        return time;
    }
}

