/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.tools.ToolingClientBasedMojoTemplate;
import org.mule.tooling.tools.support.MavenHelper;

@Mojo(name="build-tooling-client", defaultPhase=LifecyclePhase.COMPILE)
public class BuildToolingClientModelsMojo
extends ToolingClientBasedMojoTemplate {
    @Parameter(property="client-repo-dir", required=true)
    private String clientRepo;

    @Override
    protected MavenConfiguration createToolingClientMavenConfiguration() throws IOException, MojoExecutionException {
        return this.newToolingMavenConfiguration(this.settingsFile, this.clientRepo, this.offline);
    }

    @Override
    public void doExecute(Log log, ToolingRuntimeClientBootstrap clientBootstrap) throws MojoExecutionException, IOException {
        log.info((CharSequence)("Building tooling client for tooling.version " + this.tooling + " and mule.version " + this.muleVersion));
        ToolingRuntimeClient toolingClient = clientBootstrap.getToolingRuntimeClientBuilderFactory().create().build();
        if (toolingClient == null) {
            throw new MojoExecutionException("Failed to create tooling client for tooling.version " + this.tooling + " and mule.version " + this.muleVersion);
        }
        log.info((CharSequence)"Tooling client built successfully");
    }

    @Override
    protected void configureToolingCache(String originalPathCache) {
        if (StringUtils.isEmpty((CharSequence)originalPathCache)) {
            System.setProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", Files.createTempDir().getAbsolutePath());
        }
    }

    private MavenConfiguration newToolingMavenConfiguration(String settingsFile, String clientRepo, boolean offline) throws IOException, MojoExecutionException {
        File localAsRemoteRepositoryPath = MavenHelper.getM2LocalRepository();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenHelper.getBaseMavenConfBuilder(settingsFile, this.settingsSecurityFile, clientRepo, localAsRemoteRepositoryPath, offline, this.checksumPolicy);
        return mavenConfigurationBuilder.build();
    }
}

