/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;
import org.mule.tooling.tools.support.SimpleStopwatch;

public abstract class ToolingClientBasedMojoTemplate
extends AbstractMojo {
    @Parameter(property="settingsLocation", required=true)
    protected String settingsFile;
    @Parameter(property="mule-version", required=true)
    protected String muleVersion;
    @Parameter(defaultValue="false", property="settings.offline")
    protected Boolean offline;
    @Parameter(property="tooling", required=true)
    protected String tooling;
    @Parameter(property="checksumPolicy")
    protected String checksumPolicy;
    @Parameter(property="settings.security", required=false)
    protected String settingsSecurityFile;
    @Parameter(property="toolingLog4j2File", required=false)
    protected File toolingLog4j2File;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        SimpleStopwatch stopwatch = new SimpleStopwatch().start();
        ToolingRuntimeClientBootstrap clientBootstrap = null;
        String originalPathCache = System.getProperties().getProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", null);
        log.info((CharSequence)("Original tooling cache path: " + originalPathCache));
        try {
            this.configureToolingCache(originalPathCache);
            log.info((CharSequence)("Resolving tooling client dependencies using tooling.version " + this.tooling + " for mule.version " + this.muleVersion));
            log.info((CharSequence)("Using toolingCachePath: " + System.getProperties().getProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", "")));
            clientBootstrap = this.createClientBootstrap();
            this.doExecute(log, clientBootstrap);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unexpected error", (Exception)e);
        }
        finally {
            if (originalPathCache != null) {
                System.setProperty("tooling.client.ExtensionModelServiceCache.diskStore.path", originalPathCache);
            }
            log.info((CharSequence)("Finished after " + stopwatch.stop().timeSpent()));
            if (clientBootstrap != null) {
                clientBootstrap.dispose();
            }
        }
    }

    protected ToolingRuntimeClientBootstrap createClientBootstrap() throws IOException, MojoExecutionException {
        File tempFolder = Files.createTempDir();
        MavenConfiguration mavenConfiguration = this.createToolingClientMavenConfiguration();
        ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder toolingRuntimeConfigBuilder = ToolingRuntimeClientBootstrapConfiguration.builder().workingFolder(tempFolder).mavenConfiguration(mavenConfiguration).toolingVersion(this.tooling).muleVersion(this.muleVersion);
        if (this.toolingLog4j2File != null) {
            toolingRuntimeConfigBuilder.log4jConfiguration(this.toolingLog4j2File.getCanonicalFile().toURI());
        }
        ToolingRuntimeClientBootstrapConfiguration toolingRuntimeConfig = toolingRuntimeConfigBuilder.build();
        return ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap((ToolingRuntimeClientBootstrapConfiguration)toolingRuntimeConfig);
    }

    protected abstract MavenConfiguration createToolingClientMavenConfiguration() throws IOException, MojoExecutionException;

    protected abstract void doExecute(Log var1, ToolingRuntimeClientBootstrap var2) throws MojoExecutionException, IOException;

    protected abstract void configureToolingCache(String var1);
}

