/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.core.facade.BuildOutputDirectory;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorOptions;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

@MojoGoal(value="update-us")
public class UpdateSiteMojo
extends AbstractMojo {
    @MojoParameter(expression="${project}")
    private MavenProject project;
    @MojoComponent
    private EquinoxServiceFactory p2;
    @MojoParameter(expression="${update.site.url}")
    private String remoteUpdateSiteUrl;
    @MojoParameter(expression="${local.update.site.path}")
    private String localUpdateSitePath;
    @MojoParameter(expression="${destination.path}")
    private String destinationPath;

    public void execute() throws MojoExecutionException {
        RepositoryReferences remoteSourceDescriptor = new RepositoryReferences();
        RepositoryReferences localSourceDescriptor = new RepositoryReferences();
        this.addLocalUpdateSiteTo(remoteSourceDescriptor);
        this.addLocalUpdateSiteTo(localSourceDescriptor);
        this.addRemoteUpdateSiteTo(remoteSourceDescriptor);
        File destination = new File(this.destinationPath);
        DestinationRepositoryDescriptor destinationDescriptor = new DestinationRepositoryDescriptor(destination, "", true, false, true);
        this.getLog().info((CharSequence)("Mirroring to " + destination + "..."));
        try {
            this.mirror(remoteSourceDescriptor, destinationDescriptor);
        }
        catch (FacadeException e) {
            try {
                this.mirror(localSourceDescriptor, destinationDescriptor);
            }
            catch (FacadeException e1) {
                throw new MojoExecutionException("could not mirror repositories", (Exception)((Object)e));
            }
        }
    }

    private void mirror(RepositoryReferences sourceDescriptor, DestinationRepositoryDescriptor destinationDescriptor) throws FacadeException {
        MirrorApplicationService mirrorService = (MirrorApplicationService)this.p2.getService(MirrorApplicationService.class);
        mirrorService.mirrorStandalone(sourceDescriptor, destinationDescriptor, Collections.emptyList(), this.createMirrorOptions(), this.getBuildOutputDirectory());
    }

    private void addRemoteUpdateSiteTo(RepositoryReferences sourceDescriptor) {
        try {
            sourceDescriptor.addMetadataRepository(new URI(this.remoteUpdateSiteUrl));
            sourceDescriptor.addArtifactRepository(new URI(this.remoteUpdateSiteUrl));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void addLocalUpdateSiteTo(RepositoryReferences sourceDescriptor) throws MojoExecutionException {
        File localUpdateSite = new File(this.localUpdateSitePath);
        this.checkIfExists(localUpdateSite);
        sourceDescriptor.addMetadataRepository(localUpdateSite);
        sourceDescriptor.addArtifactRepository(localUpdateSite);
    }

    private void checkIfExists(File localUpdateSite) throws MojoExecutionException {
        if (!localUpdateSite.exists()) {
            throw new MojoExecutionException("Local update site does not exists");
        }
    }

    private MirrorOptions createMirrorOptions() {
        MirrorOptions options = new MirrorOptions();
        options.setFollowOnlyFilteredRequirements(false);
        options.setFollowStrictOnly(false);
        options.setIncludeFeatures(true);
        options.setIncludeNonGreedy(true);
        options.setIncludeOptional(true);
        options.setLatestVersionOnly(false);
        options.getFilter().putAll(new HashMap());
        return options;
    }

    private BuildOutputDirectory getBuildOutputDirectory() {
        return new BuildOutputDirectory(this.project.getBuild().getDirectory());
    }
}

