/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import java.util.Arrays;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class ExceptionStrategyScope
implements Scope {
    private final Element exceptionStrategy;

    public ExceptionStrategyScope(Element mule) {
        List<StatusCodeMapping> statusCodeMappings = Arrays.asList(new StatusCodeMapping(404, "org.mule.module.apikit.exception.NotFoundException", "resource not found"), new StatusCodeMapping(405, "org.mule.module.apikit.exception.MethodNotAllowedException", "method not allowed"), new StatusCodeMapping(415, "org.mule.module.apikit.exception.UnsupportedMediaTypeException", "unsupported media type"), new StatusCodeMapping(406, "org.mule.module.apikit.exception.NotAcceptableException", "not acceptable"), new StatusCodeMapping(400, "org.mule.module.apikit.exception.BadRequestException", "bad request"));
        this.exceptionStrategy = new Element("mapping-exception-strategy", APIKitTools.API_KIT_NAMESPACE.getNamespace());
        this.exceptionStrategy.setAttribute("name", "Global_Mapping_Exception_Strategy");
        for (StatusCodeMapping statusCodeMapping : statusCodeMappings) {
            Element mapping = new Element("mapping", APIKitTools.API_KIT_NAMESPACE.getNamespace());
            mapping.setAttribute("statusCode", statusCodeMapping.getStatusCode());
            Element exception = new Element("exception", APIKitTools.API_KIT_NAMESPACE.getNamespace());
            exception.setAttribute("value", statusCodeMapping.getException());
            mapping.addContent((Content)exception);
            Element setPayload = new Element("set-payload", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
            setPayload.setAttribute("value", statusCodeMapping.getMsg());
            mapping.addContent((Content)setPayload);
            this.exceptionStrategy.addContent((Content)mapping);
        }
        mule.addContent((Content)this.exceptionStrategy);
    }

    public Element generate() {
        return this.exceptionStrategy;
    }

    public static class StatusCodeMapping {
        private final int statusCode;
        private final String exception;
        private final String msg;

        public StatusCodeMapping(int statusCode, String exception, String msg) {
            this.statusCode = statusCode;
            this.exception = exception;
            this.msg = msg;
        }

        public String getStatusCode() {
            return Integer.toString(this.statusCode);
        }

        public String getException() {
            return this.exception;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

