/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.raml.model.ActionType;

public class APIKitFlow {
    private final String action;
    private final String resource;
    private final String configRef;
    public static final String APIKIT_FLOW_NAME_FORMAT = "^([^:]+):(/[^:]+)(:(.*))?$";

    public APIKitFlow(String action, String resource) {
        this(action, resource, null);
    }

    public APIKitFlow(String action, String resource, String configRef) {
        this.action = action;
        this.resource = resource;
        this.configRef = configRef;
    }

    public String getAction() {
        return this.action;
    }

    public String getResource() {
        return this.resource;
    }

    public String getConfigRef() {
        return this.configRef;
    }

    public static APIKitFlow buildFromName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Flow name cannot be null or empty");
        }
        Pattern flowNamePattern = Pattern.compile(APIKIT_FLOW_NAME_FORMAT);
        Matcher flowNameMatcher = flowNamePattern.matcher(name);
        if (!flowNameMatcher.find()) {
            throw new IllegalArgumentException("Invalid apikit flow name, expected format is: action:resource[:config]");
        }
        String action = flowNameMatcher.group(1);
        if (!APIKitFlow.isValidAction(action)) {
            throw new IllegalArgumentException(action + " is not a valid action type");
        }
        String resource = flowNameMatcher.group(2);
        String config = null;
        if (flowNameMatcher.groupCount() > 3) {
            config = flowNameMatcher.group(4);
        }
        return new APIKitFlow(action, resource, config);
    }

    private static boolean isValidAction(String name) {
        for (ActionType actionType : ActionType.values()) {
            if (!actionType.toString().toLowerCase().equals(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

