/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import org.apache.commons.lang.StringUtils;

public class APIKitConfig {
    public static final String ELEMENT_NAME = "config";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String RAML_ATTRIBUTE = "raml";
    public static final String CONSOLE_ENABLED_ATTRIBUTE = "consoleEnabled";
    public static final String CONSOLE_PATH_ATTRIBUTE = "consolePath";
    public static final String DEFAULT_CONSOLE_PATH = "console";
    private String name;
    private String raml;
    private boolean consoleEnabled;
    private String consolePath;

    private APIKitConfig(String name, String raml, boolean consoleEnabled, String consolePath) {
        this.name = name;
        this.raml = raml;
        this.consoleEnabled = consoleEnabled;
        this.consolePath = consolePath;
    }

    public String getName() {
        return this.name;
    }

    public String getRaml() {
        return this.raml;
    }

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    public String getConsolePath() {
        return this.consolePath;
    }

    public static class Builder {
        private String name;
        private final String raml;
        private boolean consoleEnabled = true;
        private String consolePath;

        public Builder(String raml) {
            if (StringUtils.isEmpty((String)raml)) {
                throw new IllegalArgumentException("Raml attribute cannot be null or empty");
            }
            this.raml = raml;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setConsoleEnabled(boolean consoleEnabled) {
            this.consoleEnabled = consoleEnabled;
            return this;
        }

        public Builder setConsolePath(String consolePath) {
            this.consolePath = consolePath;
            return this;
        }

        public APIKitConfig build() {
            return new APIKitConfig(this.name, this.raml, this.consoleEnabled, this.consolePath != null ? this.consolePath : APIKitConfig.DEFAULT_CONSOLE_PATH);
        }
    }
}

