/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.input.MuleConfigParser;
import org.mule.tools.apikit.input.RAMLFilesParser;
import org.mule.tools.apikit.misc.FileListUtils;
import org.mule.tools.apikit.model.ResourceActionPair;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.GenerationModelProvider;
import org.mule.tools.apikit.output.GenerationStrategy;
import org.mule.tools.apikit.output.MuleConfigGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scaffolder {
    private final Log log;
    private final MuleConfigGenerator muleConfigGenerator;

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles) throws MojoExecutionException {
        FileListUtils fileUtils = new FileListUtils(log);
        Map<File, InputStream> fileInputStreamMap = fileUtils.toStreamsOrFail(specFiles);
        Map<File, InputStream> streams = fileUtils.toStreamsOrFail(muleXmlFiles);
        return new Scaffolder(log, muleXmlOutputDirectory, fileInputStreamMap, streams);
    }

    public Scaffolder(Log log, File muleXmlOutputDirectory, Map<File, InputStream> yamls, Map<File, InputStream> xmls) {
        this.log = log;
        GenerationModelProvider generationModelProvider = new GenerationModelProvider();
        RAMLFilesParser RAMLFilesParser2 = new RAMLFilesParser(log, generationModelProvider, yamls);
        MuleConfigParser muleConfigParser = new MuleConfigParser(log, yamls.keySet(), xmls);
        Set<ResourceActionPair> generate = new GenerationStrategy(log).generate(RAMLFilesParser2, muleConfigParser);
        Set<GenerationModel> generationModels = generationModelProvider.generate(generate);
        this.muleConfigGenerator = new MuleConfigGenerator(log, muleXmlOutputDirectory, generationModels);
    }

    public void run() {
        this.muleConfigGenerator.generate();
    }
}

