/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.mule.tools.apikit.Scaffolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaffolderAPI {
    private static final List<String> apiExtensions = Arrays.asList(".yaml", ".raml", ".yml");
    private static final List<String> appExtensions = Arrays.asList(".xml");
    private final File apiDir;
    private final File appDir;

    public ScaffolderAPI(File apiDir, File appDir) {
        this.apiDir = apiDir;
        this.appDir = appDir;
    }

    public void run() {
        Scaffolder scaffolder;
        List<String> muleXmlFiles = this.retrieveFilePaths(this.appDir, appExtensions);
        List<String> yamlFiles = this.retrieveFilePaths(this.apiDir, apiExtensions);
        try {
            scaffolder = Scaffolder.createScaffolder((Log)new SystemStreamLog(), this.appDir, yamlFiles, muleXmlFiles);
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing scaffolder", e);
        }
        scaffolder.run();
    }

    private List<String> retrieveFilePaths(File dir, final List<String> extensions) {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File " + dir.getName() + " must be a directory");
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File file, String fileName) {
                for (String extension : extensions) {
                    if (!fileName.endsWith(extension)) continue;
                    return true;
                }
                return false;
            }
        });
        if (files != null) {
            for (File file : files) {
                filePaths.add(file.getAbsolutePath());
            }
        }
        return filePaths;
    }
}

