/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.Validate;
import org.mule.tools.apikit.model.APIKitConfig;

public class API {
    public static final String DEFAULT_BASE_URI = "http://localhost:${http.port}";
    private String baseUri;
    private APIKitConfig config;
    private File xmlFile;
    private File yamlFile;
    private static final Map<File, API> factory = new HashMap<File, API>();

    public static API createAPIBinding(File yamlFile, File xmlFile, String path) {
        return API.createAPIBinding(yamlFile, xmlFile, path, null);
    }

    public static API createAPIBinding(File yamlFile, File xmlFile, String path, APIKitConfig config) {
        Validate.notNull((Object)yamlFile);
        if (factory.containsKey(yamlFile)) {
            API api = factory.get(yamlFile);
            if (api.xmlFile == null && xmlFile != null) {
                api.xmlFile = xmlFile;
            }
            api.config = config;
            return api;
        }
        API api = new API();
        api.yamlFile = yamlFile;
        api.xmlFile = xmlFile;
        api.baseUri = path;
        api.config = config;
        factory.put(yamlFile, api);
        return api;
    }

    private API() {
    }

    public File getXmlFile(File rootDirectory) {
        if (this.xmlFile == null) {
            this.xmlFile = new File(rootDirectory, FilenameUtils.getBaseName((String)this.yamlFile.getAbsolutePath()) + ".xml");
        }
        return this.xmlFile;
    }

    public File getYamlFile() {
        return this.yamlFile;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public APIKitConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        API api = (API)o;
        return this.yamlFile.equals(api.yamlFile);
    }

    public int hashCode() {
        return this.yamlFile.hashCode();
    }
}

