/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.mule.tools.apikit.model.APIKitConfig;

public class API {
    public static final int DEFAULT_PORT = 8081;
    public static final String DEFAULT_BASE_URI = "http://localhost:8081/api";
    private String baseUri;
    private APIKitConfig config;
    private File xmlFile;
    private File yamlFile;

    public API(File yamlFile, File xmlFile, String baseUri) {
        this.baseUri = baseUri;
        this.yamlFile = yamlFile;
        this.xmlFile = xmlFile;
    }

    public API(File yamlFile, File xmlFile, String baseUri, APIKitConfig config) {
        this(yamlFile, xmlFile, baseUri);
        this.config = config;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public File getXmlFile(File rootDirectory) {
        if (this.xmlFile == null) {
            this.xmlFile = new File(rootDirectory, FilenameUtils.getBaseName((String)this.yamlFile.getAbsolutePath()) + ".xml");
        }
        return this.xmlFile;
    }

    public File getYamlFile() {
        return this.yamlFile;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public APIKitConfig getConfig() {
        return this.config;
    }

    public void setConfig(APIKitConfig config) {
        this.config = config;
    }

    public void setDefaultConfig() {
        this.config = new APIKitConfig.Builder(this.yamlFile.getName()).setName("apiConfig").build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        API api = (API)o;
        return this.yamlFile.equals(api.yamlFile);
    }

    public int hashCode() {
        return this.yamlFile.hashCode();
    }
}

