/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.tools.apikit.model.API;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Resource;
import org.raml.model.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationModel
implements Comparable<GenerationModel> {
    private static final char FLOW_NAME_SEPARATOR = ':';
    public static final String DEFAULT_TEXT = "#[NullPayload.getInstance()]";
    private final String verb;
    private Action action;
    private Resource resource;
    private List<String> splitPath;
    private API api;

    public GenerationModel(API api, Resource resource, Action action) {
        this.api = api;
        Validate.notNull((Object)api);
        Validate.notNull((Object)resource);
        Validate.notNull((Object)action);
        Validate.notNull((Object)action.getType());
        Validate.notNull((Object)resource.getUri());
        Validate.notNull((Object)action.getType());
        this.resource = resource;
        this.action = action;
        this.splitPath = new ArrayList<String>(Arrays.asList(this.resource.getUri().split("/")));
        this.verb = action.getType().toString();
        this.splitPath.remove(0);
        this.splitPath.remove(0);
    }

    public String getVerb() {
        return this.verb;
    }

    public String getStringFromActionType() {
        switch (this.action.getType()) {
            case GET: {
                return "retrieve";
            }
            case POST: {
                return "update";
            }
            case PUT: {
                return "create";
            }
            case DELETE: {
                return "delete";
            }
        }
        return this.action.getType().toString().toLowerCase();
    }

    public String getExample() {
        String exampleWrappee = this.getExampleWrappee();
        if (exampleWrappee != null) {
            return exampleWrappee;
        }
        return DEFAULT_TEXT;
    }

    private String getExampleWrappee() {
        Map responses = this.action.getResponses();
        Response response = (Response)responses.get("200");
        if (response == null || response.getBody() == null) {
            for (Response response1 : responses.values()) {
                if (response1.getBody() == null) continue;
                Map responseBody1 = response1.getBody();
                MimeType mimeType = (MimeType)responseBody1.get("application/json");
                if (mimeType != null && mimeType.getExample() != null) {
                    return mimeType.getExample();
                }
                for (MimeType type : responseBody1.values()) {
                    if (type.getExample() == null) continue;
                    return type.getExample();
                }
            }
        }
        if (response != null && response.getBody() != null) {
            Map body = response.getBody();
            MimeType mimeType = (MimeType)body.get("application/json");
            if (mimeType != null && mimeType.getExample() != null) {
                return mimeType.getExample();
            }
            for (MimeType mimeType2 : response.getBody().values()) {
                if (mimeType2 == null || mimeType2.getExample() == null) continue;
                return mimeType2.getExample();
            }
        }
        return null;
    }

    public String getName() {
        StringBuilder name = new StringBuilder();
        name.append(this.getStringFromActionType());
        String name1 = this.resource.getDisplayName();
        if (name1 == null) {
            StringBuffer buff = new StringBuffer();
            for (String i : this.splitPath) {
                buff.append(StringUtils.capitalize((String)i));
            }
            name1 = buff.toString();
        }
        name.append(name1);
        return name.toString().replace(" ", "");
    }

    public String getRelativeURI() {
        return "/" + StringUtils.join((Object[])this.splitPath.toArray(), (String)"/");
    }

    public API getApi() {
        return this.api;
    }

    public String getContentType() {
        if (this.action.getBody() != null) {
            for (String response : this.action.getResponses().keySet()) {
                int statusCode = Integer.parseInt(response);
                if (statusCode <= 200 || statusCode >= 299 || ((Response)this.action.getResponses().get(response)).getBody() == null || ((Response)this.action.getResponses().get(response)).getBody().size() <= 0) continue;
                return (String)((Response)this.action.getResponses().get(response)).getBody().keySet().toArray()[0];
            }
        }
        return null;
    }

    public String getFlowName() {
        StringBuilder flowName = new StringBuilder("");
        flowName.append(this.action.getType().toString().toLowerCase()).append(':').append(this.resource.getUri());
        if (this.api.getConfig() != null && !StringUtils.isEmpty((String)this.api.getConfig().getName())) {
            flowName.append(':').append(this.api.getConfig().getName());
        }
        return flowName.toString();
    }

    @Override
    public int compareTo(GenerationModel generationModel) {
        return this.getName().compareTo(generationModel.getName());
    }
}

