/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Scanner;
import org.mule.tools.apikit.Scaffolder;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="create")
public class CreateMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter
    private String[] specIncludes = new String[]{"src/main/api/**/*.yaml", "src/main/api/**/*.yml", "src/main/api/**/*.raml"};
    @Parameter
    private String[] specExcludes = new String[0];
    @Parameter(defaultValue="${basedir}")
    private File specDirectory;
    @Parameter
    private String[] muleXmlIncludes = new String[]{"src/main/app/**/*.xml", "src/main/resources/**/*.xml"};
    @Parameter
    private String[] muleXmlExcludes = new String[0];
    @Parameter(defaultValue="${basedir}")
    private File muleXmlDirectory;
    @Parameter(defaultValue="${basedir}/src/main/app")
    private File muleXmlOutputDirectory;
    private Log log;

    List<String> getIncludedFiles(File sourceDirectory, String[] includes, String[] excludes) {
        Scanner scanner = this.buildContext.newScanner(sourceDirectory, true);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = new File(scanner.getBasedir(), includedFiles[i]).getAbsolutePath();
        }
        String[] result = new String[includedFiles.length];
        System.arraycopy(includedFiles, 0, result, 0, includedFiles.length);
        return Arrays.asList(result);
    }

    public void execute() throws MojoExecutionException {
        Validate.notNull((Object)this.muleXmlDirectory, (String)"Error: muleXmlDirectory parameter cannot be null");
        Validate.notNull((Object)this.specDirectory, (String)"Error: specDirectory parameter cannot be null");
        this.log = this.getLog();
        List<String> specFiles = this.getIncludedFiles(this.specDirectory, this.specIncludes, this.specExcludes);
        List<String> muleXmlFiles = this.getIncludedFiles(this.muleXmlDirectory, this.muleXmlIncludes, this.muleXmlExcludes);
        this.log.info((CharSequence)("Processing the following yaml files: " + specFiles));
        this.log.info((CharSequence)("Processing the following xml files as mule configs: " + muleXmlFiles));
        Scaffolder scaffolder = Scaffolder.createScaffolder(this.log, this.muleXmlOutputDirectory, specFiles, muleXmlFiles);
        scaffolder.run();
    }
}

