/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIKitConfigParser
implements MuleConfigFileParser {
    @Override
    public Map<String, APIKitConfig> parse(Document document) {
        HashMap<String, APIKitConfig> apikitConfigs = new HashMap<String, APIKitConfig>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='config']", Filters.element((Namespace)APIKitTools.API_KIT_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            Attribute name = element.getAttribute("name");
            Attribute raml = element.getAttribute("raml");
            Attribute consoleEnabled = element.getAttribute("consoleEnabled");
            Attribute consolePath = element.getAttribute("consolePath");
            if (raml == null) {
                throw new IllegalArgumentException("raml attribute is required");
            }
            APIKitConfig.Builder configBuilder = new APIKitConfig.Builder(raml.getValue());
            if (name != null) {
                configBuilder.setName(name.getValue());
            }
            if (consoleEnabled != null) {
                configBuilder.setConsoleEnabled(Boolean.valueOf(consoleEnabled.getValue()));
            }
            if (consolePath != null) {
                configBuilder.setConsolePath(consolePath.getValue());
            }
            APIKitConfig config = configBuilder.build();
            apikitConfigs.put(config.getName(), config);
        }
        return apikitConfigs;
    }
}

