/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import java.util.Arrays;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.NamespaceWithLocation;
import org.mule.tools.apikit.output.scopes.Scope;

public class MuleScope
implements Scope {
    private final Element mule = new Element("mule");

    private void addLocationEntry(StringBuilder stringBuilder, NamespaceWithLocation namespaceWithLocation) {
        stringBuilder.append(namespaceWithLocation.getNamespace().getURI()).append(" ").append(namespaceWithLocation.getLocation()).append(" ");
    }

    public MuleScope(Document doc) {
        StringBuilder stringBuilder = new StringBuilder();
        this.mule.setNamespace(MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        this.mule.addNamespaceDeclaration(MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        this.addLocationEntry(stringBuilder, MuleConfigGenerator.XMLNS_NAMESPACE);
        List<NamespaceWithLocation> namespaces = Arrays.asList(MuleConfigGenerator.HTTP_NAMESPACE, APIKitTools.API_KIT_NAMESPACE, MuleConfigGenerator.SPRING_NAMESPACE);
        this.mule.addNamespaceDeclaration(MuleConfigGenerator.XSI_NAMESPACE.getNamespace());
        for (NamespaceWithLocation namespace : namespaces) {
            this.mule.addNamespaceDeclaration(namespace.getNamespace());
            this.addLocationEntry(stringBuilder, namespace);
        }
        this.mule.setAttribute("schemaLocation", stringBuilder.toString(), MuleConfigGenerator.XSI_NAMESPACE.getNamespace());
        doc.setRootElement(this.mule);
    }

    public Element generate() {
        return this.mule;
    }
}

