/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.input.APIDiff;
import org.mule.tools.apikit.input.MuleConfigParser;
import org.mule.tools.apikit.input.RAMLFilesParser;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.ResourceActionPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationStrategy {
    private Log log;

    public GenerationStrategy(Log log) {
        this.log = log;
    }

    public Set<ResourceActionPair> generate(RAMLFilesParser RAMLFilesParser2, MuleConfigParser muleConfigParser) {
        Set<API> apisInMuleConfigs = muleConfigParser.getIncludedApis();
        Set<ResourceActionPair> yamlEntries = RAMLFilesParser2.getEntries();
        Set<ResourceActionPair> muleFlowEntries = muleConfigParser.getEntries();
        if (apisInMuleConfigs.isEmpty()) {
            if (yamlEntries.isEmpty()) {
                this.log.info((CharSequence)"No APIs or APIKit flows found.");
                return yamlEntries;
            }
            this.log.info((CharSequence)("Generating apikit:flows for the following operations: " + yamlEntries));
            return yamlEntries;
        }
        if (yamlEntries.isEmpty()) {
            this.log.warn((CharSequence)("The following apikit:flows do not match any RAML API binding: " + apisInMuleConfigs));
            return yamlEntries;
        }
        Set<ResourceActionPair> flowEntries1 = new APIDiff(yamlEntries, muleFlowEntries).getEntries();
        this.log.info((CharSequence)("Adding new apikit:flows to existing files for the following operations: " + flowEntries1));
        return flowEntries1;
    }
}

