/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ResourceActionPair;
import org.mule.tools.apikit.output.GenerationModelProvider;
import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMLFilesParser {
    private final GenerationModelProvider generationModelProvider;
    private Set<ResourceActionPair> entries = new HashSet<ResourceActionPair>();
    private final APIFactory apiFactory;

    public RAMLFilesParser(Log log, GenerationModelProvider generationModelProvider, Map<File, InputStream> fileStreams, APIFactory apiFactory) {
        this.generationModelProvider = generationModelProvider;
        this.apiFactory = apiFactory;
        ArrayList<File> processedFiles = new ArrayList<File>();
        for (Map.Entry<File, InputStream> fileInputStreamEntry : fileStreams.entrySet()) {
            String content;
            File ramlFile = fileInputStreamEntry.getKey();
            try {
                content = IOUtils.toString((InputStream)fileInputStreamEntry.getValue());
            }
            catch (IOException ioe) {
                log.info((CharSequence)("Error loading file " + ramlFile.getName()));
                break;
            }
            CompositeResourceLoader resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new FileResourceLoader(ramlFile.getParentFile())});
            if (!this.isValidYaml(ramlFile.getName(), content, (ResourceLoader)resourceLoader, log)) continue;
            RamlDocumentBuilder builderNodeHandler = new RamlDocumentBuilder((ResourceLoader)resourceLoader, new TagResolver[0]);
            try {
                Raml raml = (Raml)builderNodeHandler.build(content, ramlFile.getName());
                this.collectResources(ramlFile, this.entries, raml.getResources(), "http://localhost:8081/api");
                processedFiles.add(ramlFile);
            }
            catch (Exception e) {
                log.info((CharSequence)("Could not parse [" + ramlFile + "] as root RAML file. Reason: " + e.getMessage()));
                log.debug((Throwable)e);
            }
        }
        if (processedFiles.size() > 0) {
            log.info((CharSequence)("The following RAML files were parsed correctly: " + processedFiles));
        } else {
            log.error((CharSequence)"RAML Root not found. None of the files were recognized as valid root RAML files.");
        }
    }

    private boolean isValidYaml(String fileName, String content, ResourceLoader resourceLoader, Log log) {
        List validationResults = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (TagResolver[])new TagResolver[0]).validate(content, fileName);
        if (validationResults != null && !validationResults.isEmpty()) {
            log.info((CharSequence)("File '" + fileName + "' is not a valid root RAML file. See following error(s): "));
            int errorCount = 1;
            for (ValidationResult validationResult : validationResults) {
                log.info((CharSequence)("Error " + errorCount + ": " + validationResult.toString()));
                ++errorCount;
            }
            return false;
        }
        return true;
    }

    void collectResources(File filename, Set<ResourceActionPair> resources, Map<String, Resource> resourceMap, String baseUri) {
        for (Resource resource : resourceMap.values()) {
            for (Action action : resource.getActions().values()) {
                API api = this.apiFactory.createAPIBinding(filename, null, baseUri, null);
                String path = APIKitTools.getPathFromUri(baseUri);
                ResourceActionPair resourceActionPair = new ResourceActionPair(api, path + resource.getUri(), action.getType().toString());
                this.generationModelProvider.add(api, resourceActionPair, resource, action);
                resources.add(resourceActionPair);
            }
            this.collectResources(filename, resources, resource.getResources(), baseUri);
        }
    }

    public Set<ResourceActionPair> getEntries() {
        return this.entries;
    }
}

