/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.APIKitFlow;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.ResourceActionPair;
import org.mule.tools.apikit.output.MuleConfigGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIKitFlowsParser
implements MuleConfigFileParser {
    private static final Logger LOGGER = Logger.getLogger(APIKitFlowsParser.class);
    private final Map<String, API> includedApis;

    public APIKitFlowsParser(Map<String, API> includedApis) {
        this.includedApis = includedApis;
    }

    @Override
    public Set<ResourceActionPair> parse(Document document) {
        HashSet<ResourceActionPair> entries = new HashSet<ResourceActionPair>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='flow']", Filters.element((Namespace)MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            APIKitFlow flow;
            String name = element.getAttributeValue("name");
            try {
                flow = APIKitFlow.buildFromName(name);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.info((Object)("Flow named '" + name + "' is not an APIKit Flow because it does not follow APIKit naming convention."));
                continue;
            }
            API api = this.includedApis.get(flow.getConfigRef());
            String resource = flow.getResource();
            if (api != null) {
                String path;
                if (!resource.startsWith("/")) {
                    resource = "/" + resource;
                }
                if ((path = APIKitTools.getPathFromUri(api.getBaseUri())) == null) {
                    throw new IllegalStateException("Inbound-endpoint Address URI is invalid");
                }
                entries.add(new ResourceActionPair(api, path + resource, flow.getAction()));
                continue;
            }
            throw new IllegalStateException("No APIKit entries found in Mule config");
        }
        return entries;
    }
}

