/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.APIKitConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIKitRoutersParser
implements MuleConfigFileParser {
    private final Map<String, APIKitConfig> apikitConfigs;
    private final Set<File> yamlPaths;
    private final File file;
    private final APIFactory apiFactory;

    public APIKitRoutersParser(Map<String, APIKitConfig> apikitConfigs, Set<File> yamlPaths, File file, APIFactory apiFactory) {
        this.apikitConfigs = apikitConfigs;
        this.yamlPaths = yamlPaths;
        this.file = file;
        this.apiFactory = apiFactory;
    }

    @Override
    public Map<String, API> parse(Document document) {
        HashMap<String, API> includedApis = new HashMap<String, API>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='router']", Filters.element((Namespace)APIKitTools.API_KIT_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            Attribute configRef = element.getAttribute("config-ref");
            String configId = configRef != null ? configRef.getValue() : "noNameConfig";
            APIKitConfig config = this.apikitConfigs.get(configId);
            if (config == null) {
                throw new IllegalStateException("An Apikit configuration is mandatory.");
            }
            for (File yamlPath : this.yamlPaths) {
                if (!yamlPath.getName().equals(config.getRaml())) continue;
                Element inboundEndpoint = (Element)element.getParentElement().getChildren().get(0);
                if (!"inbound-endpoint".equals(inboundEndpoint.getName())) {
                    throw new IllegalStateException("The first element of the main flow must be an inbound-endpoint");
                }
                String path = inboundEndpoint.getAttributeValue("path");
                if (path == null) {
                    String address = inboundEndpoint.getAttributeValue("address");
                    if (address == null) {
                        throw new IllegalStateException("Neither 'path' nor 'address' attribute was used. Cannot retrieve base URI.");
                    }
                    path = address;
                } else if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                includedApis.put(configId, this.apiFactory.createAPIBinding(yamlPath, this.file, path, config));
            }
        }
        return includedApis;
    }
}

