/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.tools.apikit.output.deployer.MuleDeployProperties;

public class MuleDeployPropertiesParser {
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_CONFIG_BUILDER = "config.builder";
    public static final String PROPERTY_DOMAIN = "domain";
    public static final String PROPERTY_CONFIG_RESOURCES = "config.resources";
    public static final String PROPERTY_REDEPLOYMENT_ENABLED = "redeployment.enabled";
    public static final String PROPERTY_LOADER_OVERRIDE = "loader.override";
    public static final String PROPERTY_SCAN_PACKAGES = "scan.packages";

    public MuleDeployProperties parse(File muleDeployFile) {
        try {
            Properties p = this.loadProperties(new FileInputStream(muleDeployFile));
            MuleDeployProperties deployProperties = new MuleDeployProperties();
            deployProperties.setEncoding(p.getProperty(PROPERTY_ENCODING));
            deployProperties.setConfigurationBuilder(p.getProperty(PROPERTY_CONFIG_BUILDER));
            deployProperties.setDomain(p.getProperty(PROPERTY_DOMAIN));
            deployProperties.setPackagesToScan(p.getProperty(PROPERTY_SCAN_PACKAGES));
            String resProps = p.getProperty(PROPERTY_CONFIG_RESOURCES);
            if (!StringUtils.isBlank((String)resProps)) {
                String[] urls = resProps.split(",");
                deployProperties.setConfigResources(Arrays.asList(urls));
            }
            deployProperties.setRedeploymentEnabled(BooleanUtils.toBoolean((String)p.getProperty(PROPERTY_REDEPLOYMENT_ENABLED, Boolean.TRUE.toString())));
            deployProperties.setLoaderOverride(p.getProperty(PROPERTY_LOADER_OVERRIDE));
            return deployProperties;
        }
        catch (IOException ioe) {
            return new MuleDeployProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(FileInputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Error, properties input stream is null");
        }
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }
}

