/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListenerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIKitRoutersParser
implements MuleConfigFileParser {
    private final Map<String, APIKitConfig> apikitConfigs;
    private final Map<String, HttpListenerConfig> httpListenerConfigs;
    private final Set<File> ramlPaths;
    private final File file;
    private final APIFactory apiFactory;

    public APIKitRoutersParser(Map<String, APIKitConfig> apikitConfigs, Map<String, HttpListenerConfig> httpListenerConfigs, Set<File> ramlPaths, File file, APIFactory apiFactory) {
        this.apikitConfigs = apikitConfigs;
        this.httpListenerConfigs = httpListenerConfigs;
        this.ramlPaths = ramlPaths;
        this.file = file;
        this.apiFactory = apiFactory;
    }

    @Override
    public Map<String, API> parse(Document document) {
        HashMap<String, API> includedApis = new HashMap<String, API>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='router']", Filters.element((Namespace)APIKitTools.API_KIT_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            Attribute configRef = element.getAttribute("config-ref");
            String configId = configRef != null ? configRef.getValue() : "noNameConfig";
            APIKitConfig config = this.apikitConfigs.get(configId);
            if (config == null) {
                throw new IllegalStateException("An Apikit configuration is mandatory.");
            }
            for (File ramlPath : this.ramlPaths) {
                String path;
                if (!ramlPath.getName().equals(config.getRaml())) continue;
                Element inbound = this.findListenerOrInboundEndpoint(element.getParentElement().getChildren());
                if (inbound == null) {
                    throw new IllegalStateException("The main flow must have an inbound-endpoint or listener");
                }
                if ("listener".equals(inbound.getName())) {
                    HttpListenerConfig httpListenerConfig = this.getHTTPListenerConfig(inbound);
                    path = this.getPathFromInbound(inbound);
                    includedApis.put(configId, this.apiFactory.createAPIBinding(ramlPath, this.file, path, config, httpListenerConfig));
                    continue;
                }
                if ("inbound-endpoint".equals(inbound.getName())) {
                    String baseUri = null;
                    path = inbound.getAttributeValue("path");
                    if (path == null) {
                        baseUri = inbound.getAttributeValue("address");
                        if (baseUri == null) {
                            throw new IllegalStateException("Neither 'path' nor 'address' attribute was used. Cannot retrieve base URI.");
                        }
                        path = APIKitTools.getPathFromUri(baseUri, false);
                    } else if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    includedApis.put(configId, this.apiFactory.createAPIBinding(ramlPath, this.file, baseUri, path, config));
                    continue;
                }
                throw new IllegalStateException("The first element of the main flow must be an inbound-endpoint or listener");
            }
        }
        return includedApis;
    }

    private Element findListenerOrInboundEndpoint(List<Element> elements) {
        for (Element element : elements) {
            if (!"listener".equals(element.getName()) && !"inbound-endpoint".equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    private HttpListenerConfig getHTTPListenerConfig(Element inbound) {
        Attribute httpListenerConfigRef = inbound.getAttribute("config-ref");
        String httpListenerConfigId = httpListenerConfigRef != null ? httpListenerConfigRef.getValue() : "httpListenerConfig";
        HttpListenerConfig httpListenerConfig = this.httpListenerConfigs.get(httpListenerConfigId);
        if (httpListenerConfig == null) {
            throw new IllegalStateException("An HTTP Listener configuration is mandatory.");
        }
        return httpListenerConfig;
    }

    private String getPathFromInbound(Element inbound) {
        String address = inbound.getAttributeValue("address");
        if (address != null) {
            return APIKitTools.getPathFromUri(address, false);
        }
        String path = inbound.getAttributeValue("path");
        if (path == null) {
            path = "";
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }
}

