/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.input.APIDiff;
import org.mule.tools.apikit.input.MuleConfigParser;
import org.mule.tools.apikit.input.RAMLFilesParser;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.output.GenerationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationStrategy {
    private Log log;

    public GenerationStrategy(Log log) {
        this.log = log;
    }

    public List<GenerationModel> generate(RAMLFilesParser RAMLFilesParser2, MuleConfigParser muleConfigParser) {
        Set<API> apisInMuleConfigs = muleConfigParser.getIncludedApis();
        Set<ResourceActionMimeTypeTriplet> ramlEntries = RAMLFilesParser2.getEntries().keySet();
        Set<ResourceActionMimeTypeTriplet> muleFlowEntries = muleConfigParser.getEntries();
        ArrayList<GenerationModel> generationModels = new ArrayList<GenerationModel>();
        if (apisInMuleConfigs.isEmpty()) {
            if (ramlEntries.isEmpty()) {
                this.log.info((CharSequence)"No APIs or APIKit flows found.");
            } else {
                this.log.info((CharSequence)("Generating apikit:flows for the following operations: " + ramlEntries));
            }
            generationModels.addAll(RAMLFilesParser2.getEntries().values());
        } else if (ramlEntries.isEmpty()) {
            this.log.warn((CharSequence)("The following apikit:flows do not match any RAML API binding: " + apisInMuleConfigs));
            generationModels.addAll(RAMLFilesParser2.getEntries().values());
        } else {
            Set<ResourceActionMimeTypeTriplet> diffTriplets = new APIDiff(ramlEntries, muleFlowEntries).getEntries();
            this.log.info((CharSequence)("Adding new apikit:flows to existing files for the following operations: " + diffTriplets));
            for (ResourceActionMimeTypeTriplet entry : diffTriplets) {
                if (!RAMLFilesParser2.getEntries().containsKey(entry)) continue;
                generationModels.add(RAMLFilesParser2.getEntries().get(entry));
            }
        }
        Collections.sort(generationModels);
        return generationModels;
    }
}

