/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListenerConfig;

public class API {
    public static final int DEFAULT_PORT = 8081;
    public static final String DEFAULT_BASE_URI = "http://localhost:8081/api";
    public static final String DEFAULT_BASE_PATH = "/";
    private APIKitConfig config;
    private HttpListenerConfig httpListenerConfig;
    private String path;
    private String baseUri;
    private File xmlFile;
    private File ramlFile;
    private String id;
    private Boolean useInboundEndpoint;

    public API(File ramlFile, File xmlFile, String baseUri, String path) {
        this.path = path;
        this.ramlFile = ramlFile;
        this.xmlFile = xmlFile;
        this.baseUri = baseUri;
        this.id = FilenameUtils.removeExtension((String)ramlFile.getName()).trim();
    }

    public API(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config) {
        this(ramlFile, xmlFile, baseUri, path);
        this.config = config;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public File getXmlFile(File rootDirectory) {
        if (this.xmlFile == null) {
            this.xmlFile = new File(rootDirectory, FilenameUtils.getBaseName((String)this.ramlFile.getAbsolutePath()) + ".xml");
        }
        return this.xmlFile;
    }

    public File getRamlFile() {
        return this.ramlFile;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HttpListenerConfig getHttpListenerConfig() {
        return this.httpListenerConfig;
    }

    public APIKitConfig getConfig() {
        return this.config;
    }

    public void setConfig(APIKitConfig config) {
        this.config = config;
    }

    public void setHttpListenerConfig(HttpListenerConfig httpListenerConfig) {
        this.httpListenerConfig = httpListenerConfig;
    }

    public void setDefaultAPIKitConfig() {
        this.config = new APIKitConfig.Builder(this.ramlFile.getName()).setName(this.id + "-" + "config").build();
    }

    public void setDefaultHttpListenerConfig() {
        String httpListenerConfigName = this.id == null ? "httpListenerConfig" : this.id + "-" + "httpListenerConfig";
        this.httpListenerConfig = new HttpListenerConfig.Builder(httpListenerConfigName, DEFAULT_BASE_URI).build();
    }

    public Boolean useInboundEndpoint() {
        return this.useInboundEndpoint;
    }

    public boolean setUseInboundEndpoint(Boolean useInboundEndpoint) {
        this.useInboundEndpoint = useInboundEndpoint;
        return this.useInboundEndpoint;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        API api = (API)o;
        return this.ramlFile.equals(api.ramlFile);
    }

    public int hashCode() {
        return this.ramlFile.hashCode();
    }

    public String getId() {
        return this.id;
    }
}

