/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.Validate;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListenerConfig;

public class APIFactory {
    private Map<File, API> apis = new HashMap<File, API>();

    public API createAPIBinding(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config) {
        return this.createAPIBinding(ramlFile, xmlFile, baseUri, path, config, null, true);
    }

    public API createAPIBinding(File ramlFile, File xmlFile, String path, APIKitConfig config, HttpListenerConfig httpListenerConfig) {
        return this.createAPIBinding(ramlFile, xmlFile, null, path, config, httpListenerConfig, false);
    }

    public API createAPIBinding(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config, HttpListenerConfig httpListenerConfig, Boolean useInboundEndpoint) {
        Validate.notNull((Object)ramlFile);
        if (this.apis.containsKey(ramlFile)) {
            API api = this.apis.get(ramlFile);
            if (api.getXmlFile() == null && xmlFile != null) {
                api.setXmlFile(xmlFile);
            }
            api.setUseInboundEndpoint(useInboundEndpoint);
            if (httpListenerConfig == null && !useInboundEndpoint.booleanValue()) {
                httpListenerConfig = this.createHttpListenerConfig(ramlFile, baseUri);
            }
            api.setHttpListenerConfig(httpListenerConfig);
            api.setConfig(config);
            return api;
        }
        API api = new API(ramlFile, xmlFile, baseUri, path, config);
        api.setUseInboundEndpoint(useInboundEndpoint);
        if (httpListenerConfig == null && !useInboundEndpoint.booleanValue()) {
            httpListenerConfig = this.createHttpListenerConfig(ramlFile, baseUri);
        }
        api.setHttpListenerConfig(httpListenerConfig);
        this.apis.put(ramlFile, api);
        return api;
    }

    private HttpListenerConfig createHttpListenerConfig(File ramlFile, String baseUri) {
        String id = FilenameUtils.removeExtension((String)ramlFile.getName()).trim();
        String httpListenerConfigName = id == null ? "httpListenerConfig" : id + "-" + "httpListenerConfig";
        return new HttpListenerConfig.Builder(httpListenerConfigName, baseUri).build();
    }
}

