/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.tools.apikit.output.deployer.MuleDeployProperties;
import org.mule.tools.apikit.output.deployer.MuleDeployPropertiesParser;
import org.mule.tools.apikit.output.deployer.MuleDeployPropertiesWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleDeployWriter {
    private static final String MULE_CONFIG_PATTERN = "*.xml";
    private static final String DEPLOY_FILE_PATTERN = "mule-deploy.properties";
    private static final String DEFAULT_CONFIGURATION_RESOURCE = "mule-config.xml";
    private final File appDir;

    public MuleDeployWriter(File appDir) {
        this.appDir = appDir;
    }

    public void generate() {
        try {
            Collection muleFiles = FileUtils.listFiles((File)this.appDir, (IOFileFilter)new WildcardFileFilter(MULE_CONFIG_PATTERN), null);
            List<String> configNames = this.getConfigNames(muleFiles);
            if (this.generateDeployProperties(configNames)) {
                File deployPropertiesFile = new File(this.appDir, DEPLOY_FILE_PATTERN);
                MuleDeployProperties deployProperties = this.updateConfigResources(configNames, deployPropertiesFile);
                MuleDeployPropertiesWriter.write(deployProperties, deployPropertiesFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean generateDeployProperties(List<String> configNames) {
        return !configNames.isEmpty() && (configNames.size() != 1 || !DEFAULT_CONFIGURATION_RESOURCE.equals(configNames.get(0)));
    }

    private MuleDeployProperties updateConfigResources(List<String> configNames, File deployPropertiesFile) {
        MuleDeployProperties properties = deployPropertiesFile.exists() ? new MuleDeployPropertiesParser().parse(deployPropertiesFile) : new MuleDeployProperties();
        HashSet<String> mergeConfigResources = new HashSet<String>(properties.getConfigResources());
        mergeConfigResources.addAll(configNames);
        ArrayList<String> allResources = new ArrayList<String>(mergeConfigResources);
        if (allResources.contains(DEFAULT_CONFIGURATION_RESOURCE)) {
            allResources.remove(DEFAULT_CONFIGURATION_RESOURCE);
            allResources.add(0, DEFAULT_CONFIGURATION_RESOURCE);
        }
        properties.setConfigResources(allResources);
        return properties;
    }

    private List<String> getConfigNames(Collection<File> muleFiles) {
        ArrayList<String> configNames = new ArrayList<String>();
        if (muleFiles != null && !muleFiles.isEmpty()) {
            for (File configFile : muleFiles) {
                configNames.add(configFile.getName());
            }
        }
        return configNames;
    }
}

