/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.raml.model.ActionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIKitFlow {
    public static final String UNNAMED_CONFIG_NAME = "noNameConfig";
    private final String action;
    private final String resource;
    private final String configRef;
    private final String mimeType;
    public static final String APIKIT_FLOW_NAME_FORMAT = "^([^:]+):(/[^:]*)(:([^:]+))?(:(.*))?$";

    public APIKitFlow(String action, String resource, String mimeType, String configRef) {
        this.action = action;
        this.resource = resource;
        this.mimeType = mimeType;
        this.configRef = configRef != null ? configRef : UNNAMED_CONFIG_NAME;
    }

    public String getAction() {
        return this.action;
    }

    public String getResource() {
        return this.resource;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getConfigRef() {
        return this.configRef;
    }

    public static APIKitFlow buildFromName(String name, Collection<String> existingConfigs) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Flow name cannot be null or empty");
        }
        Pattern flowNamePattern = Pattern.compile(APIKIT_FLOW_NAME_FORMAT);
        Matcher flowNameMatcher = flowNamePattern.matcher(name);
        if (!flowNameMatcher.find()) {
            throw new IllegalArgumentException("Invalid apikit flow name, expected format is: action:resource[:config]");
        }
        String action = flowNameMatcher.group(1);
        if (!APIKitFlow.isValidAction(action)) {
            throw new IllegalArgumentException(action + " is not a valid action type");
        }
        String resource = flowNameMatcher.group(2);
        String mimeType = null;
        String config = null;
        if (flowNameMatcher.groupCount() > 5) {
            if (flowNameMatcher.group(6) == null) {
                if (existingConfigs != null && existingConfigs.contains(flowNameMatcher.group(4))) {
                    config = flowNameMatcher.group(4);
                } else {
                    mimeType = flowNameMatcher.group(4);
                }
            } else {
                mimeType = flowNameMatcher.group(4);
                config = flowNameMatcher.group(6);
            }
        }
        return new APIKitFlow(action, resource, mimeType, config);
    }

    private static boolean isValidAction(String name) {
        for (ActionType actionType : ActionType.values()) {
            if (!actionType.toString().toLowerCase().equals(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

