/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.input.MuleConfigParser;
import org.mule.tools.apikit.input.MuleDomainParser;
import org.mule.tools.apikit.input.RAMLFilesParser;
import org.mule.tools.apikit.misc.FileListUtils;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.GenerationStrategy;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class Scaffolder {
    private final MuleConfigGenerator muleConfigGenerator;

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles) throws MojoExecutionException {
        return Scaffolder.createScaffolder(log, muleXmlOutputDirectory, specFiles, muleXmlFiles, null);
    }

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles, String domainFile) throws MojoExecutionException {
        FileListUtils fileUtils = new FileListUtils(log);
        Map<File, InputStream> fileInputStreamMap = fileUtils.toStreamsOrFail(specFiles);
        Map<File, InputStream> streams = fileUtils.toStreamsOrFail(muleXmlFiles);
        InputStream domainStream = Scaffolder.getDomainStream(log, domainFile);
        return new Scaffolder(log, muleXmlOutputDirectory, fileInputStreamMap, streams, domainStream);
    }

    public Scaffolder(Log log, File muleXmlOutputDirectory, Map<File, InputStream> ramls, Map<File, InputStream> xmls, InputStream domainStream) {
        MuleDomainParser muleDomainParser = new MuleDomainParser(log, domainStream);
        APIFactory apiFactory = new APIFactory(muleDomainParser.getHttpListenerConfigs());
        MuleConfigParser muleConfigParser = new MuleConfigParser(log, ramls.keySet(), xmls, apiFactory);
        RAMLFilesParser RAMLFilesParser2 = new RAMLFilesParser(log, ramls, apiFactory);
        List<GenerationModel> generationModels = new GenerationStrategy(log).generate(RAMLFilesParser2, muleConfigParser);
        this.muleConfigGenerator = new MuleConfigGenerator(log, muleXmlOutputDirectory, generationModels, muleDomainParser.getHttpListenerConfigs());
    }

    private static InputStream getDomainStream(Log log, String domainPath) {
        FileInputStream domainStream = null;
        if (domainPath != null) {
            File domain = null;
            try {
                domain = new File(domainPath);
                domainStream = new FileInputStream(domain);
            }
            catch (FileNotFoundException e) {
                if (log != null) {
                    log.error((CharSequence)("Error opening file [" + domain + "] file"), (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
        return domainStream;
    }

    public void run() {
        this.muleConfigGenerator.generate();
    }
}

