/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.mule.tools.apikit.ExtensionManager;
import org.mule.tools.apikit.Scaffolder;

public class ScaffolderAPI {
    private static final List<String> apiExtensions = Arrays.asList(".yaml", ".raml", ".yml");
    private static final List<String> appExtensions = Arrays.asList(".xml");

    public void run(List<File> ramlFiles, File appDir) {
        this.run(ramlFiles, appDir, null);
    }

    public void run(List<File> ramlFiles, File appDir, File domainDir) {
        if (ExtensionManager.isScaffolderExtensionEnabled()) {
            ExtensionManager.getScaffolderExtension().executeScaffolder(ramlFiles, appDir, domainDir);
        } else {
            this.execute(ramlFiles, appDir, domainDir);
        }
    }

    public void execute(List<File> ramlFiles, File appDir, File domainDir) {
        Scaffolder scaffolder;
        List<String> domainFiles;
        List<String> ramlFilePaths = this.retrieveFilePaths(ramlFiles, apiExtensions);
        List<String> muleXmlFiles = this.retrieveFilePaths(appDir, appExtensions);
        SystemStreamLog log = new SystemStreamLog();
        String domain = null;
        if (domainDir != null && (domainFiles = this.retrieveFilePaths(domainDir, appExtensions)).size() > 0) {
            domain = domainFiles.get(0);
            if (domainFiles.size() > 1) {
                log.info((CharSequence)("There is more than one domain file inside of the domain folder. The domain: " + domain + " will be used."));
            }
        }
        try {
            scaffolder = Scaffolder.createScaffolder((Log)log, appDir, ramlFilePaths, muleXmlFiles, domain);
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing scaffolder", e);
        }
        scaffolder.run();
    }

    private List<String> retrieveFilePaths(File dir, List<String> extensions) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File " + dir.getName() + " must be a directory");
        }
        return this.retrieveFilePaths(new ArrayList<File>(Arrays.asList(dir.listFiles())), extensions);
    }

    private List<String> retrieveFilePaths(List<File> files, List<String> extensions) {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                if (!this.containsValidExtension(file, extensions)) continue;
                filePaths.add(file.getAbsolutePath());
            }
        }
        return filePaths;
    }

    private boolean containsValidExtension(File file, List<String> extensions) {
        for (String extension : extensions) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

