/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.logging.Log;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.NamespaceWithLocation;
import org.mule.tools.apikit.output.deployer.MuleDeployWriter;
import org.mule.tools.apikit.output.scopes.APIKitConfigScope;
import org.mule.tools.apikit.output.scopes.APIKitFlowScope;
import org.mule.tools.apikit.output.scopes.ExceptionStrategyScope;
import org.mule.tools.apikit.output.scopes.FlowScope;
import org.mule.tools.apikit.output.scopes.HttpListenerConfigScope;
import org.mule.tools.apikit.output.scopes.MuleScope;

public class MuleConfigGenerator {
    public static final NamespaceWithLocation XMLNS_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core"), "http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
    public static final NamespaceWithLocation XSI_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), null);
    public static final NamespaceWithLocation HTTP_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http"), "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd");
    public static final NamespaceWithLocation SPRING_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"spring", (String)"http://www.springframework.org/schema/beans"), "http://www.springframework.org/schema/beans/spring-beans-3.1.xsd");
    private static final String INDENTATION = "    ";
    private final List<GenerationModel> flowEntries;
    private final Log log;
    private final File rootDirectory;
    private final Map<String, HttpListenerConfig> domainHttpListenerConfigs;
    private final String muleVersion;
    private final Set<File> ramlsWithExtensionEnabled;

    public MuleConfigGenerator(Log log, File muleConfigOutputDirectory, List<GenerationModel> flowEntries, Map<String, HttpListenerConfig> domainHttpListenerConfigs, String muleVersion, Set<File> ramlsWithExtensionEnabled) {
        this.log = log;
        this.flowEntries = flowEntries;
        this.rootDirectory = muleConfigOutputDirectory;
        this.domainHttpListenerConfigs = domainHttpListenerConfigs;
        this.muleVersion = muleVersion;
        this.ramlsWithExtensionEnabled = ramlsWithExtensionEnabled == null ? new TreeSet<File>() : ramlsWithExtensionEnabled;
    }

    public void generate() {
        HashMap<API, Document> docs = new HashMap<API, Document>();
        for (GenerationModel generationModel : this.flowEntries) {
            Document doc;
            API api = generationModel.getApi();
            try {
                doc = this.getOrCreateDocument(docs, api);
            }
            catch (Exception e) {
                this.log.error((CharSequence)("Error generating xml for file: [" + api.getRamlFile() + "]"), (Throwable)e);
                continue;
            }
            int index = this.getLastFlowIndex(doc) + 1;
            doc.getRootElement().addContent(index, (Content)new APIKitFlowScope(generationModel).generate());
        }
        for (Map.Entry entry : docs.entrySet()) {
            Format prettyFormat = Format.getPrettyFormat();
            prettyFormat.setIndent(INDENTATION);
            prettyFormat.setLineSeparator(System.getProperty("line.separator"));
            prettyFormat.setEncoding("UTF-8");
            XMLOutputter xout = new XMLOutputter(prettyFormat);
            Document doc = (Document)entry.getValue();
            File xmlFile = ((API)entry.getKey()).getXmlFile(this.rootDirectory);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(xmlFile);
                xout.output(doc, (OutputStream)fileOutputStream);
                fileOutputStream.close();
                this.log.info((CharSequence)("Updating file: [" + xmlFile + "]"));
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Error writing to file: [" + xmlFile + "]"), (Throwable)e);
            }
        }
        new MuleDeployWriter(this.rootDirectory).generate();
    }

    private int getLastFlowIndex(Document doc) {
        int lastFlowIndex = 0;
        for (int i = 0; i < doc.getRootElement().getContentSize(); ++i) {
            Content content = doc.getRootElement().getContent(i);
            if (!(content instanceof Element) || !"flow".equals(((Element)content).getName())) continue;
            lastFlowIndex = i;
        }
        return lastFlowIndex;
    }

    Document getOrCreateDocument(Map<API, Document> docs, API api) throws IOException, JDOMException {
        Document doc;
        if (docs.containsKey(api)) {
            doc = docs.get(api);
        } else {
            doc = this.getDocument(api);
            if (api.getConfig() == null || !api.useInboundEndpoint().booleanValue() && api.getHttpListenerConfig() == null) {
                if (api.getConfig() == null) {
                    api.setDefaultAPIKitConfig();
                }
                if (this.ramlsWithExtensionEnabled.contains(api.getRamlFile())) {
                    api.getConfig().setExtensionEnabled(true);
                }
                this.generateAPIKitAndListenerConfig(api, doc);
            }
            docs.put(api, doc);
        }
        return doc;
    }

    private Document getDocument(API api) throws IOException, JDOMException {
        Document doc;
        SAXBuilder saxBuilder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        File xmlFile = api.getXmlFile(this.rootDirectory);
        if (!xmlFile.exists() || xmlFile.length() == 0L) {
            xmlFile.getParentFile().mkdirs();
            doc = new Document();
            doc.setRootElement(new MuleScope().generate());
        } else {
            FileInputStream xmlInputStream = new FileInputStream(xmlFile);
            doc = saxBuilder.build((InputStream)xmlInputStream);
        }
        return doc;
    }

    private void generateAPIKitAndListenerConfig(API api, Document doc) {
        XPathExpression muleExp = XPathFactory.instance().compile("//*[local-name()='mule']");
        List mules = muleExp.evaluate((Object)doc);
        Element mule = (Element)mules.get(0);
        String listenerConfigRef = null;
        if (!api.useInboundEndpoint().booleanValue()) {
            if (!this.domainHttpListenerConfigs.containsKey(api.getHttpListenerConfig().getName())) {
                new HttpListenerConfigScope(api, mule).generate();
            }
            listenerConfigRef = api.getHttpListenerConfig().getName();
            api.setPath(APIKitTools.addAsteriskToPath(api.getPath()));
        }
        new APIKitConfigScope(api.getConfig(), mule, this.muleVersion).generate();
        Element exceptionStrategy = new ExceptionStrategyScope(api.getId()).generate();
        String configRef = api.getConfig() != null ? api.getConfig().getName() : null;
        new FlowScope(mule, exceptionStrategy.getAttribute("name").getValue(), api, configRef, listenerConfigRef).generate();
        mule.addContent((Content)exceptionStrategy);
    }
}

