/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import org.apache.commons.lang.StringUtils;

public class APIKitConfig {
    public static final String ELEMENT_NAME = "config";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String RAML_ATTRIBUTE = "raml";
    public static final String CONSOLE_ENABLED_ATTRIBUTE = "consoleEnabled";
    public static final String EXTENSION_ENABLED_ATTRIBUTE = "extensionEnabled";
    public static final String CONSOLE_PATH_ATTRIBUTE = "consolePath";
    public static final String DEFAULT_CONSOLE_PATH = "console";
    public static final String DEFAULT_CONFIG_NAME = "config";
    private String name;
    private String raml;
    private boolean consoleEnabled;
    private Boolean extensionEnabled;
    private String consolePath;

    private APIKitConfig(String name, String raml, boolean consoleEnabled, Boolean extensionEnabled, String consolePath) {
        this.name = name;
        this.raml = raml;
        this.consoleEnabled = consoleEnabled;
        this.extensionEnabled = extensionEnabled;
        this.consolePath = consolePath;
    }

    public String getName() {
        return this.name;
    }

    public String getRaml() {
        return this.raml;
    }

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    public Boolean isExtensionEnabled() {
        return this.extensionEnabled;
    }

    public void setExtensionEnabled(Boolean enabled) {
        this.extensionEnabled = enabled;
    }

    public String getConsolePath() {
        return this.consolePath;
    }

    public static class Builder {
        private String name;
        private final String raml;
        private boolean consoleEnabled = true;
        private Boolean extensionEnabled = null;
        private String consolePath;

        public Builder(String raml) {
            if (StringUtils.isEmpty((String)raml)) {
                throw new IllegalArgumentException("Raml attribute cannot be null or empty");
            }
            this.raml = raml;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setConsoleEnabled(boolean consoleEnabled) {
            this.consoleEnabled = consoleEnabled;
            return this;
        }

        public Builder setExtensionEnabled(boolean extensionEnabled) {
            this.extensionEnabled = extensionEnabled;
            return this;
        }

        public Builder setConsolePath(String consolePath) {
            this.consolePath = consolePath;
            return this;
        }

        public APIKitConfig build() {
            return new APIKitConfig(this.name, this.raml, this.consoleEnabled, this.extensionEnabled, this.consolePath != null ? this.consolePath : APIKitConfig.DEFAULT_CONSOLE_PATH);
        }
    }
}

