/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import org.apache.commons.lang.StringUtils;
import org.mule.tools.apikit.misc.APIKitTools;

public class HttpListenerConfig {
    public static final String ELEMENT_NAME = "listener-config";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DEFAULT_CONFIG_NAME = "httpListenerConfig";
    private String name;
    private String host;
    private String port;
    private String basePath;

    public HttpListenerConfig(String name, String host, String port, String basePath) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.basePath = basePath;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public static class Builder {
        private String name;
        private String host;
        private String port;
        private String basePath;

        public Builder(String name, String host, String port, String basePath) {
            if (StringUtils.isEmpty((String)name)) {
                throw new IllegalArgumentException("Name attribute cannot be null or empty");
            }
            if (StringUtils.isEmpty((String)host)) {
                throw new IllegalArgumentException("Host attribute cannot be null or empty");
            }
            if (StringUtils.isEmpty((String)port)) {
                throw new IllegalArgumentException("Port attribute cannot be null or empty");
            }
            this.name = name;
            this.host = host;
            this.port = port;
            this.basePath = basePath;
        }

        public Builder(String name, String baseUri) {
            this.name = name;
            this.host = APIKitTools.getHostFromUri(baseUri);
            if (this.host == "") {
                this.host = APIKitTools.getHostFromUri("http://0.0.0.0:8081/api");
            }
            this.port = APIKitTools.getPortFromUri(baseUri);
            if (this.port == "") {
                this.port = APIKitTools.getPortFromUri("http://0.0.0.0:8081/api");
            }
            this.basePath = "/";
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public Builder setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder() {
            this.name = HttpListenerConfig.DEFAULT_CONFIG_NAME;
            this.host = APIKitTools.getHostFromUri("http://0.0.0.0:8081/api");
            this.port = APIKitTools.getPortFromUri("http://0.0.0.0:8081/api");
            this.basePath = "/";
        }

        public HttpListenerConfig build() {
            return new HttpListenerConfig(this.name, this.host, this.port, this.basePath);
        }
    }
}

